/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smartcardio.CardException;
import net.jsign.DigestAlgorithm;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.DigestInfo;
import net.jsign.jca.OpenPGPCard;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class OpenPGPCardSigningService
implements SigningService {
    private final OpenPGPCard pgpcard;
    private final Function<String, Certificate[]> certificateStore;

    public OpenPGPCardSigningService(String pin, Function<String, Certificate[]> certificateStore) throws CardException {
        OpenPGPCard pgpcard = OpenPGPCard.getCard();
        if (pgpcard == null) {
            throw new CardException("OpenPGP card not found");
        }
        this.certificateStore = certificateStore;
        this.pgpcard = pgpcard;
        this.pgpcard.verify(pin);
    }

    @Override
    public String getName() {
        return "OPENPGP";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        try {
            Set<OpenPGPCard.Key> keys = this.pgpcard.getAvailableKeys();
            return keys.stream().map(Enum::name).collect(Collectors.toList());
        }
        catch (CardException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        LinkedHashMap<String, Certificate> certificates;
        block7: {
            certificates = new LinkedHashMap<String, Certificate>();
            try {
                OpenPGPCard.Key key = OpenPGPCard.Key.valueOf(alias);
                ByteArrayInputStream data = new ByteArrayInputStream(this.pgpcard.getCertificate(key));
                data.mark(0);
                if (data.available() <= 0) break block7;
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                try {
                    Certificate[] chain;
                    for (Certificate certificate : chain = factory.generateCertPath(data).getCertificates().toArray(new Certificate[0])) {
                        String subject = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                        certificates.put(subject, certificate);
                    }
                }
                catch (CertificateException e) {
                    data.reset();
                    Certificate certificate = factory.generateCertificate(data);
                    String subject = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                    certificates.put(subject, certificate);
                }
            }
            catch (CertificateException | CardException e) {
                throw new KeyStoreException(e);
            }
        }
        if (this.certificateStore != null) {
            for (Certificate certificate : this.certificateStore.apply(alias)) {
                String subject = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                certificates.put(subject, certificate);
            }
        }
        return certificates.values().toArray(new Certificate[0]);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        String algorithm;
        OpenPGPCard.KeyInfo keyInfo;
        try {
            keyInfo = this.pgpcard.getKeyInfo(OpenPGPCard.Key.valueOf(alias));
        }
        catch (CardException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to retrieve the info for key " + alias).initCause(e);
        }
        if (keyInfo.isRSA()) {
            algorithm = "RSA";
        } else if (keyInfo.isEC()) {
            algorithm = "ECDSA";
        } else {
            throw new UnrecoverableKeyException("Unsupported key algorithm " + keyInfo.algorithm + " for key " + alias);
        }
        return new SigningServicePrivateKey(alias, algorithm);
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        byte[] digest = digestAlgorithm.getMessageDigest().digest(data);
        try {
            byte[] content;
            if ("RSA".equals(privateKey.getAlgorithm())) {
                DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(digestAlgorithm.oid, DERNull.INSTANCE), digest);
                content = digestInfo.getEncoded("DER");
            } else {
                content = digest;
            }
            return this.pgpcard.sign(OpenPGPCard.Key.valueOf(privateKey.getId()), content);
        }
        catch (IOException | CardException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

