/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.jsign.log4j.spi.DefaultThreadContextStack;
import net.jsign.log4j.spi.NoOpThreadContextMap;
import net.jsign.log4j.spi.ReadOnlyThreadContextMap;
import net.jsign.log4j.spi.ThreadContextMap;
import net.jsign.log4j.spi.ThreadContextMapFactory;
import net.jsign.log4j.spi.ThreadContextStack;
import net.jsign.log4j.util.PropertiesUtil;

public final class ThreadContext {
    public static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final ThreadContextStack EMPTY_STACK = new EmptyThreadContextStack();
    private static boolean useStack;
    private static ThreadContextMap contextMap;
    private static ThreadContextStack contextStack;
    private static ReadOnlyThreadContextMap readOnlyContextMap;

    static void init() {
        ThreadContextMapFactory.init();
        contextMap = null;
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        boolean disableAll = managerProps.getBooleanProperty("disableThreadContext");
        useStack = !managerProps.getBooleanProperty("disableThreadContextStack") && !disableAll;
        boolean useMap = !managerProps.getBooleanProperty("disableThreadContextMap") && !disableAll;
        contextStack = new DefaultThreadContextStack(useStack);
        contextMap = !useMap ? new NoOpThreadContextMap() : ThreadContextMapFactory.createThreadContextMap();
        readOnlyContextMap = contextMap instanceof ReadOnlyThreadContextMap ? (ReadOnlyThreadContextMap)((Object)contextMap) : null;
    }

    public static Map<String, String> getImmutableContext() {
        Map<String, String> map = contextMap.getImmutableMapOrNull();
        return map == null ? EMPTY_MAP : map;
    }

    static {
        ThreadContext.init();
    }

    public static interface ContextStack
    extends Serializable,
    Collection<String> {
        public List<String> asList();
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException("This is an empty iterator!");
        }

        @Override
        public void remove() {
        }
    }

    private static class EmptyThreadContextStack
    extends AbstractCollection<String>
    implements ThreadContextStack {
        private static final Iterator<String> EMPTY_ITERATOR = new EmptyIterator<String>();

        private EmptyThreadContextStack() {
        }

        @Override
        public List<String> asList() {
            return Collections.emptyList();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Collection && ((Collection)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(String e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

