/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.timestamp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jsign.DigestAlgorithm;
import net.jsign.asn1.authenticode.AuthenticodeSignedDataGenerator;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.ASN1Sequence;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.AttributeTable;
import net.jsign.bouncycastle.cert.X509CertificateHolder;
import net.jsign.bouncycastle.cms.CMSException;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.bouncycastle.cms.SignerInformationStore;
import net.jsign.bouncycastle.util.CollectionStore;
import net.jsign.timestamp.AuthenticodeTimestamper;
import net.jsign.timestamp.RFC3161Timestamper;
import net.jsign.timestamp.TimestampingException;
import net.jsign.timestamp.TimestampingMode;

public abstract class Timestamper {
    protected URL tsaurl;
    protected List<URL> tsaurls;
    protected int retries = 3;
    protected int retryWait = 10;

    public void setURL(String tsaurl) {
        this.setURLs(tsaurl);
    }

    public void setURLs(String ... tsaurls) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String tsaurl : tsaurls) {
            try {
                urls.add(new URL(tsaurl));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid timestamping URL: " + tsaurl, e);
            }
        }
        this.tsaurls = urls;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRetryWait(int retryWait) {
        this.retryWait = retryWait;
    }

    public CMSSignedData timestamp(DigestAlgorithm algo, CMSSignedData sigData) throws TimestampingException, IOException, CMSException {
        CMSSignedData token = null;
        int attempts = Math.max(this.retries, this.tsaurls.size());
        TimestampingException exception = new TimestampingException("Unable to complete the timestamping after " + attempts + " attempt" + (attempts > 1 ? "s" : ""));
        int count = 0;
        while (count < Math.max(this.retries, this.tsaurls.size())) {
            try {
                this.tsaurl = this.tsaurls.get(count % this.tsaurls.size());
                token = this.timestamp(algo, this.getEncryptedDigest(sigData));
                break;
            }
            catch (IOException | TimestampingException e) {
                exception.addSuppressed(e);
                try {
                    Thread.sleep((long)this.retryWait * 1000L);
                    ++count;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (token == null) {
            throw exception;
        }
        return this.modifySignedData(sigData, this.getCounterSignature(token), this.getExtraCertificates(token));
    }

    private byte[] getEncryptedDigest(CMSSignedData sigData) {
        SignerInformation signerInformation = sigData.getSignerInfos().getSigners().iterator().next();
        return signerInformation.toASN1Structure().getEncryptedDigest().getOctets();
    }

    protected Collection<X509CertificateHolder> getExtraCertificates(CMSSignedData token) {
        return null;
    }

    protected abstract Attribute getCounterSignature(CMSSignedData var1);

    @Deprecated
    protected AttributeTable getUnsignedAttributes(CMSSignedData token) {
        return new AttributeTable(this.getCounterSignature(token));
    }

    @Deprecated
    protected CMSSignedData modifySignedData(CMSSignedData sigData, AttributeTable counterSignature, Collection<X509CertificateHolder> extraCertificates) throws IOException, CMSException {
        return this.modifySignedData(sigData, Attribute.getInstance(counterSignature.toASN1EncodableVector().get(0)), extraCertificates);
    }

    protected CMSSignedData modifySignedData(CMSSignedData sigData, Attribute counterSignature, Collection<X509CertificateHolder> extraCertificates) throws IOException, CMSException {
        SignerInformation signerInformation = sigData.getSignerInfos().getSigners().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        unsignedAttributes = unsignedAttributes == null ? new AttributeTable(counterSignature) : unsignedAttributes.add(counterSignature.getAttrType(), counterSignature.getAttrValues());
        signerInformation = SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributes);
        ArrayList<X509CertificateHolder> certificates = new ArrayList<X509CertificateHolder>();
        certificates.addAll(sigData.getCertificates().getMatches(null));
        if (extraCertificates != null) {
            certificates.addAll(extraCertificates);
        }
        CollectionStore certificateStore = new CollectionStore(certificates);
        AuthenticodeSignedDataGenerator generator = new AuthenticodeSignedDataGenerator();
        generator.addCertificates(certificateStore);
        generator.addSigners(new SignerInformationStore(signerInformation));
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier(sigData.getSignedContentTypeOID());
        ASN1Sequence content = ASN1Sequence.getInstance(sigData.getSignedContent().getContent());
        return generator.generate(contentType, content);
    }

    protected abstract CMSSignedData timestamp(DigestAlgorithm var1, byte[] var2) throws IOException, TimestampingException;

    public static Timestamper create(TimestampingMode mode) {
        switch (mode) {
            case AUTHENTICODE: {
                return new AuthenticodeTimestamper();
            }
            case RFC3161: {
                return new RFC3161Timestamper();
            }
        }
        throw new IllegalArgumentException("Unsupported timestamping mode: " + (Object)((Object)mode));
    }
}

