/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jsign.commons.codec.binary.Hex;

class TLV {
    private String tag;
    private byte[] value;
    private List<TLV> children;

    TLV() {
    }

    public byte[] value() {
        return this.value;
    }

    public TLV find(String ... tags) {
        if (tags.length == 0) {
            return this;
        }
        if (this.children != null) {
            List<TLV> values = this.children;
            String tag = tags[0];
            for (TLV value : values) {
                if (!value.tag.equals(tag)) continue;
                return value.find(Arrays.copyOfRange(tags, 1, tags.length));
            }
        }
        return null;
    }

    public String toString() {
        if (this.children == null) {
            return "[TLV tag=" + this.tag + " value(" + this.value.length + ")=" + Hex.encodeHexString(this.value).toUpperCase() + "]";
        }
        return "[TLV tag=" + this.tag + " children=" + this.children + "]";
    }

    public static TLV parse(ByteBuffer buffer) {
        List<TLV> map = TLV.parseList(buffer);
        if (map.size() == 1) {
            return map.get(0);
        }
        TLV tlv = new TLV();
        tlv.children = map;
        return tlv;
    }

    private static List<TLV> parseList(ByteBuffer buffer) {
        ArrayList<TLV> list = new ArrayList<TLV>();
        while (buffer.hasRemaining()) {
            byte[] value;
            int length;
            boolean constructed;
            int tag = buffer.get() & 0xFF;
            boolean bl = constructed = (tag & 0x20) != 0;
            if ((tag & 0x1F) == 31) {
                tag = tag << 8 | buffer.get() & 0xFF;
                while ((tag & 0x80) != 0) {
                    tag = tag << 8 | buffer.get() & 0xFF;
                }
            }
            if ((length = TLV.parseLength(buffer)) >= 0) {
                value = new byte[length];
                buffer.get(value);
            } else {
                buffer.mark();
                int zeroCount = 0;
                while (zeroCount < 2 && buffer.hasRemaining()) {
                    if (buffer.get() == 0) {
                        ++zeroCount;
                        continue;
                    }
                    zeroCount = 0;
                }
                long position = buffer.position();
                buffer.reset();
                value = new byte[(int)(position - (long)buffer.position() - 2L)];
                buffer.get(value);
            }
            TLV tlv = new TLV();
            tlv.tag = Integer.toHexString(tag).toUpperCase();
            tlv.value = value;
            if (constructed) {
                tlv.children = TLV.parseList(ByteBuffer.wrap(value));
            }
            list.add(tlv);
        }
        return list;
    }

    private static int parseLength(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        if (length < 128) {
            return length;
        }
        if (length > 128) {
            int n = length & 0x7F;
            length = 0;
            for (int i = 0; i < n; ++i) {
                length = length << 8 | buffer.get() & 0xFF;
            }
        } else {
            return -1;
        }
        return length;
    }
}

