/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.simple;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.jsign.log4j.Level;
import net.jsign.log4j.message.MessageFactory;
import net.jsign.log4j.simple.SimpleLogger;
import net.jsign.log4j.spi.AbstractLogger;
import net.jsign.log4j.spi.ExtendedLogger;
import net.jsign.log4j.spi.LoggerContext;
import net.jsign.log4j.spi.LoggerRegistry;
import net.jsign.log4j.util.PropertiesUtil;

public class SimpleLoggerContext
implements LoggerContext {
    static final SimpleLoggerContext INSTANCE = new SimpleLoggerContext();
    private final PropertiesUtil props;
    private final boolean showLogName;
    private final boolean showShortName;
    private final boolean showDateTime;
    private final boolean showContextMap;
    private final String dateTimeFormat;
    private final Level defaultLevel;
    private final PrintStream stream;
    private final LoggerRegistry<ExtendedLogger> loggerRegistry = new LoggerRegistry();

    public SimpleLoggerContext() {
        PrintStream ps;
        this.props = new PropertiesUtil("log4j2.simplelog.properties");
        this.showContextMap = this.props.getBooleanProperty("net.jsign.log4j.simplelog.showContextMap", false);
        this.showLogName = this.props.getBooleanProperty("net.jsign.log4j.simplelog.showlogname", false);
        this.showShortName = this.props.getBooleanProperty("net.jsign.log4j.simplelog.showShortLogname", true);
        this.showDateTime = this.props.getBooleanProperty("net.jsign.log4j.simplelog.showdatetime", false);
        String lvl = this.props.getStringProperty("net.jsign.log4j.simplelog.level");
        this.defaultLevel = Level.toLevel(lvl, Level.ERROR);
        this.dateTimeFormat = this.showDateTime ? this.props.getStringProperty("net.jsign.log4j.simplelog.dateTimeFormat", "yyyy/MM/dd HH:mm:ss:SSS zzz") : null;
        String fileName = this.props.getStringProperty("net.jsign.log4j.simplelog.logFile", "system.err");
        if ("system.err".equalsIgnoreCase(fileName)) {
            ps = System.err;
        } else if ("system.out".equalsIgnoreCase(fileName)) {
            ps = System.out;
        } else {
            try {
                ps = new PrintStream(new FileOutputStream(fileName));
            }
            catch (FileNotFoundException fnfe) {
                ps = System.err;
            }
        }
        this.stream = ps;
    }

    @Override
    public ExtendedLogger getLogger(String name) {
        return this.getLogger(name, null);
    }

    public ExtendedLogger getLogger(String name, MessageFactory messageFactory) {
        ExtendedLogger extendedLogger = this.loggerRegistry.getLogger(name, messageFactory);
        if (extendedLogger != null) {
            AbstractLogger.checkMessageFactory(extendedLogger, messageFactory);
            return extendedLogger;
        }
        SimpleLogger simpleLogger = new SimpleLogger(name, this.defaultLevel, this.showLogName, this.showShortName, this.showDateTime, this.showContextMap, this.dateTimeFormat, messageFactory, this.props, this.stream);
        this.loggerRegistry.putIfAbsent(name, messageFactory, simpleLogger);
        return this.loggerRegistry.getLogger(name, messageFactory);
    }
}

