/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import net.jsign.log4j.util.BiConsumer;
import net.jsign.log4j.util.PropertySource;

public class PropertiesPropertySource
implements PropertySource {
    private final Properties properties;
    private final int priority;

    public PropertiesPropertySource(Properties properties) {
        this(properties, 200);
    }

    public PropertiesPropertySource(Properties properties, int priority) {
        this.properties = properties;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void forEach(BiConsumer<String, String> action) {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            action.accept((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return "log4j2." + PropertySource.Util.joinAsCamelCase(tokens);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public boolean containsProperty(String key) {
        return this.getProperty(key) != null;
    }
}

