/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.pe;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcPeImageData;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.AttributeTable;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.DigestInfo;
import net.jsign.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import net.jsign.bouncycastle.cert.X509CertificateHolder;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.pe.CertificateTableEntry;
import net.jsign.pe.DataDirectory;
import net.jsign.pe.DataDirectoryType;
import net.jsign.pe.MachineType;
import net.jsign.pe.PEFormat;
import net.jsign.pe.PEImageChecksum;
import net.jsign.pe.Section;
import net.jsign.pe.Subsystem;

public class PEFile
implements Signable {
    public final long peHeaderOffset;
    private File file;
    final SeekableByteChannel channel;
    private final ByteBuffer valueBuffer = ByteBuffer.allocate(8);

    public static boolean isPEFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        try {
            PEFile peFile = new PEFile(file);
            peFile.close();
            return true;
        }
        catch (IOException e) {
            if (e.getMessage().contains("DOS header signature not found") || e.getMessage().contains("PE signature not found")) {
                return false;
            }
            throw e;
        }
    }

    public PEFile(File file) throws IOException {
        this(Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));
        this.file = file;
    }

    public PEFile(SeekableByteChannel channel) throws IOException {
        this.valueBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.channel = channel;
        try {
            this.read(0L, 0, 2);
            if (this.valueBuffer.get() != 77 || this.valueBuffer.get() != 90) {
                throw new IOException("DOS header signature not found");
            }
            this.read(60L, 0, 4);
            this.peHeaderOffset = (long)this.valueBuffer.getInt() & 0xFFFFFFFFL;
            this.read(this.peHeaderOffset, 0, 4);
            if (this.valueBuffer.get() != 80 || this.valueBuffer.get() != 69 || this.valueBuffer.get() != 0 || this.valueBuffer.get() != 0) {
                throw new IOException("PE signature not found as expected at offset 0x" + Long.toHexString(this.peHeaderOffset));
            }
        }
        catch (IOException e) {
            channel.close();
            throw e;
        }
    }

    @Override
    public void save() {
    }

    @Override
    public synchronized void close() throws IOException {
        this.channel.close();
    }

    synchronized int read(byte[] buffer, long base, int offset) {
        try {
            this.channel.position(base + (long)offset);
            return this.channel.read(ByteBuffer.wrap(buffer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void read(long base, int offset, int length) {
        try {
            this.valueBuffer.limit(length);
            this.valueBuffer.clear();
            this.channel.position(base + (long)offset);
            this.channel.read(this.valueBuffer);
            this.valueBuffer.rewind();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    synchronized int read(long base, int offset) {
        this.read(base, offset, 1);
        return this.valueBuffer.get();
    }

    synchronized int readWord(long base, int offset) {
        this.read(base, offset, 2);
        return this.valueBuffer.getShort() & 0xFFFF;
    }

    synchronized long readDWord(long base, int offset) {
        this.read(base, offset, 4);
        return (long)this.valueBuffer.getInt() & 0xFFFFFFFFL;
    }

    synchronized long readQWord(long base, int offset) {
        this.read(base, offset, 8);
        return this.valueBuffer.getLong();
    }

    synchronized void write(long base, byte[] data) {
        try {
            this.channel.position(base);
            this.channel.write(ByteBuffer.wrap(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MachineType getMachineType() {
        return MachineType.valueOf(this.readWord(this.peHeaderOffset, 4));
    }

    public int getNumberOfSections() {
        return this.readWord(this.peHeaderOffset, 6);
    }

    public Date getTimeDateStamp() {
        return new Date(1000L * this.readDWord(this.peHeaderOffset, 8));
    }

    public long getPointerToSymbolTable() {
        return this.readDWord(this.peHeaderOffset, 12);
    }

    public long getNumberOfSymbols() {
        return this.readDWord(this.peHeaderOffset, 16);
    }

    public int getSizeOfOptionalHeader() {
        return this.readWord(this.peHeaderOffset, 20);
    }

    public int getCharacteristics() {
        return this.readWord(this.peHeaderOffset, 22);
    }

    public PEFormat getFormat() {
        return PEFormat.valueOf(this.readWord(this.peHeaderOffset, 24));
    }

    public int getMajorLinkerVersion() {
        return this.read(this.peHeaderOffset, 26);
    }

    public int getMinorLinkerVersion() {
        return this.read(this.peHeaderOffset, 27);
    }

    public long getSizeOfCode() {
        return this.readDWord(this.peHeaderOffset, 28);
    }

    public long getSizeOfInitializedData() {
        return this.readDWord(this.peHeaderOffset, 32);
    }

    public long getSizeOfUninitializedData() {
        return this.readDWord(this.peHeaderOffset, 36);
    }

    public long getAddressOfEntryPoint() {
        return this.readDWord(this.peHeaderOffset, 40);
    }

    public long getBaseOfCode() {
        return this.readDWord(this.peHeaderOffset, 44);
    }

    public long getBaseOfData() {
        if (PEFormat.PE32.equals((Object)this.getFormat())) {
            return this.readDWord(this.peHeaderOffset, 48);
        }
        return 0L;
    }

    public long getImageBase() {
        if (PEFormat.PE32.equals((Object)this.getFormat())) {
            return this.readDWord(this.peHeaderOffset, 52);
        }
        return this.readQWord(this.peHeaderOffset, 48);
    }

    public long getSectionAlignment() {
        return this.readDWord(this.peHeaderOffset, 56);
    }

    public long getFileAlignment() {
        return this.readDWord(this.peHeaderOffset, 60);
    }

    public int getMajorOperatingSystemVersion() {
        return this.readWord(this.peHeaderOffset, 64);
    }

    public int getMinorOperatingSystemVersion() {
        return this.readWord(this.peHeaderOffset, 66);
    }

    public int getMajorImageVersion() {
        return this.readWord(this.peHeaderOffset, 68);
    }

    public int getMinorImageVersion() {
        return this.readWord(this.peHeaderOffset, 70);
    }

    public int getMajorSubsystemVersion() {
        return this.readWord(this.peHeaderOffset, 72);
    }

    public int getMinorSubsystemVersion() {
        return this.readWord(this.peHeaderOffset, 74);
    }

    public long getWin32VersionValue() {
        return this.readDWord(this.peHeaderOffset, 76);
    }

    public long getSizeOfImage() {
        return this.readDWord(this.peHeaderOffset, 80);
    }

    public long getSizeOfHeaders() {
        return this.readDWord(this.peHeaderOffset, 84);
    }

    public long getCheckSum() {
        return this.readDWord(this.peHeaderOffset, 88);
    }

    public synchronized long computeChecksum() {
        PEImageChecksum checksum = new PEImageChecksum(this.peHeaderOffset + 88L);
        ByteBuffer b = ByteBuffer.allocate(65536);
        try {
            int len;
            this.channel.position(0L);
            while ((len = this.channel.read(b)) > 0) {
                b.flip();
                checksum.update(b.array(), 0, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return checksum.getValue();
    }

    public synchronized void updateChecksum() {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt((int)this.computeChecksum());
        buffer.flip();
        try {
            this.channel.position(this.peHeaderOffset + 88L);
            this.channel.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Subsystem getSubsystem() {
        return Subsystem.valueOf(this.readWord(this.peHeaderOffset, 92));
    }

    public int getDllCharacteristics() {
        return this.readWord(this.peHeaderOffset, 94);
    }

    public long getSizeOfStackReserve() {
        if (PEFormat.PE32.equals((Object)this.getFormat())) {
            return this.readDWord(this.peHeaderOffset, 96);
        }
        return this.readQWord(this.peHeaderOffset, 96);
    }

    public long getSizeOfStackCommit() {
        if (PEFormat.PE32.equals((Object)this.getFormat())) {
            return this.readDWord(this.peHeaderOffset, 100);
        }
        return this.readQWord(this.peHeaderOffset, 104);
    }

    public long getSizeOfHeapReserve() {
        if (PEFormat.PE32.equals((Object)this.getFormat())) {
            return this.readDWord(this.peHeaderOffset, 104);
        }
        return this.readQWord(this.peHeaderOffset, 112);
    }

    public long getSizeOfHeapCommit() {
        if (PEFormat.PE32.equals((Object)this.getFormat())) {
            return this.readDWord(this.peHeaderOffset, 108);
        }
        return this.readQWord(this.peHeaderOffset, 120);
    }

    public long getLoaderFlags() {
        return this.readDWord(this.peHeaderOffset, PEFormat.PE32.equals((Object)this.getFormat()) ? 112 : 128);
    }

    public int getNumberOfRvaAndSizes() {
        return (int)this.readDWord(this.peHeaderOffset, PEFormat.PE32.equals((Object)this.getFormat()) ? 116 : 132);
    }

    int getDataDirectoryOffset() {
        return (int)this.peHeaderOffset + (PEFormat.PE32.equals((Object)this.getFormat()) ? 120 : 136);
    }

    public DataDirectory getDataDirectory(DataDirectoryType type) {
        if (type.ordinal() >= this.getNumberOfRvaAndSizes()) {
            return null;
        }
        return new DataDirectory(this, type.ordinal());
    }

    public synchronized void writeDataDirectory(DataDirectoryType type, byte[] data) throws IOException {
        DataDirectory directory = this.getDataDirectory(type);
        if (directory == null) {
            throw new IOException("No space allocated in the data directories index for the " + (Object)((Object)type) + " directory");
        }
        if (!directory.exists()) {
            long offset = this.channel.size();
            this.channel.position(offset);
            this.channel.write(ByteBuffer.wrap(data));
            directory.write(offset, data.length);
        } else if (data.length == directory.getSize()) {
            this.channel.position(directory.getVirtualAddress());
            this.channel.write(ByteBuffer.wrap(data));
        } else if (data.length < directory.getSize() && type != DataDirectoryType.CERTIFICATE_TABLE) {
            directory.erase();
            this.channel.position(directory.getVirtualAddress());
            this.channel.write(ByteBuffer.wrap(data));
            directory.write(directory.getVirtualAddress(), data.length);
        } else if (directory.isTrailing()) {
            this.channel.position(directory.getVirtualAddress());
            this.channel.write(ByteBuffer.wrap(data));
            this.channel.truncate(directory.getVirtualAddress() + (long)data.length);
            directory.write(directory.getVirtualAddress(), data.length);
        } else {
            if (type == DataDirectoryType.CERTIFICATE_TABLE) {
                throw new IOException("The certificate table isn't at the end of the file and can't be moved without invalidating the signature");
            }
            directory.erase();
            long offset = this.channel.size();
            this.channel.position(offset);
            this.channel.write(ByteBuffer.wrap(data));
            directory.write(offset, data.length);
        }
        this.updateChecksum();
    }

    @Override
    public synchronized List<CMSSignedData> getSignatures() {
        ArrayList<CMSSignedData> signatures = new ArrayList<CMSSignedData>();
        for (CertificateTableEntry entry : this.getCertificateTable()) {
            try {
                Attribute nestedSignatures;
                CMSSignedData signedData = entry.getSignature();
                signatures.add(signedData);
                SignerInformation signerInformation = signedData.getSignerInfos().getSigners().iterator().next();
                AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
                if (unsignedAttributes == null || (nestedSignatures = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID)) == null) continue;
                for (ASN1Encodable nestedSignature : nestedSignatures.getAttrValues()) {
                    signatures.add(new CMSSignedData(null, ContentInfo.getInstance(nestedSignature)));
                }
            }
            catch (UnsupportedOperationException signedData) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return signatures;
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        DataDirectory certificateTable = this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE);
        if (certificateTable == null || !certificateTable.exists()) {
            this.pad(8);
        }
        CertificateTableEntry entry = new CertificateTableEntry(signature);
        this.writeDataDirectory(DataDirectoryType.CERTIFICATE_TABLE, entry.toBytes());
    }

    private synchronized List<CertificateTableEntry> getCertificateTable() {
        ArrayList<CertificateTableEntry> entries = new ArrayList<CertificateTableEntry>();
        DataDirectory certificateTable = this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE);
        if (certificateTable != null && certificateTable.exists()) {
            long position = certificateTable.getVirtualAddress();
            try {
                if (position < this.channel.size()) {
                    entries.add(new CertificateTableEntry(this, position));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entries;
    }

    public synchronized List<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        int sectionTableOffset = this.getDataDirectoryOffset() + 8 * this.getNumberOfRvaAndSizes();
        for (int i = 0; i < this.getNumberOfSections(); ++i) {
            sections.add(new Section(this, sectionTableOffset + 40 * i));
        }
        return sections;
    }

    public void printInfo(OutputStream out) {
        this.printInfo(new PrintWriter(out, true));
    }

    public void printInfo(PrintWriter out) {
        if (this.file != null) {
            out.println("PE File");
            out.println("  Name:          " + this.file.getName());
            out.println("  Size:          " + this.file.length());
            out.println("  Last Modified: " + new Date(this.file.lastModified()));
            out.println();
        }
        out.println("PE Header");
        out.println("  Machine:                    " + (Object)((Object)this.getMachineType()));
        out.println("  Number of sections:         " + this.getNumberOfSections());
        out.println("  Timestamp:                  " + this.getTimeDateStamp());
        out.println("  Pointer to symbol table:    0x" + Long.toHexString(this.getPointerToSymbolTable()));
        out.println("  Number of symbols:          " + this.getNumberOfSymbols());
        out.println("  Size of optional header:    " + this.getSizeOfOptionalHeader());
        out.println("  Characteristics:            0x" + Long.toBinaryString(this.getCharacteristics()));
        out.println();
        out.println("Optional Header");
        PEFormat format = this.getFormat();
        out.println("  PE Format:                  0x" + Integer.toHexString(format.value) + " (" + format.label + ")");
        out.println("  Linker version:             " + this.getMajorLinkerVersion() + "." + this.getMinorLinkerVersion());
        out.println("  Size of code:               " + this.getSizeOfCode());
        out.println("  Size of initialized data:   " + this.getSizeOfInitializedData());
        out.println("  Size of uninitialized data: " + this.getSizeOfUninitializedData());
        out.println("  Address of entry point:     0x" + Long.toHexString(this.getAddressOfEntryPoint()));
        out.println("  Base of code:               0x" + Long.toHexString(this.getBaseOfCode()));
        if (PEFormat.PE32.equals((Object)this.getFormat())) {
            out.println("  Base of data:               0x" + Long.toHexString(this.getBaseOfData()));
        }
        out.println("  Image base:                 0x" + Long.toHexString(this.getImageBase()));
        out.println("  Section alignment:          " + this.getSectionAlignment());
        out.println("  File alignment:             " + this.getFileAlignment());
        out.println("  Operating system version:   " + this.getMajorOperatingSystemVersion() + "." + this.getMinorOperatingSystemVersion());
        out.println("  Image version:              " + this.getMajorImageVersion() + "." + this.getMinorImageVersion());
        out.println("  Subsystem version:          " + this.getMajorSubsystemVersion() + "." + this.getMinorSubsystemVersion());
        out.println("  Size of image:              " + this.getSizeOfImage());
        out.println("  Size of headers:            " + this.getSizeOfHeaders());
        out.println("  Checksum:                   0x" + Long.toHexString(this.getCheckSum()));
        out.println("  Checksum (computed):        0x" + Long.toHexString(this.computeChecksum()));
        out.println("  Subsystem:                  " + (Object)((Object)this.getSubsystem()));
        out.println("  DLL characteristics:        0x" + Long.toBinaryString(this.getDllCharacteristics()));
        out.println("  Size of stack reserve:      " + this.getSizeOfStackReserve());
        out.println("  Size of stack commit:       " + this.getSizeOfStackCommit());
        out.println("  Size of heap reserve:       " + this.getSizeOfHeapReserve());
        out.println("  Size of heap commit:        " + this.getSizeOfHeapCommit());
        out.println("  Number of RVA and sizes:    " + this.getNumberOfRvaAndSizes());
        out.println();
        out.println("Data Directory");
        for (DataDirectoryType type : DataDirectoryType.values()) {
            DataDirectory entry = this.getDataDirectory(type);
            if (entry == null || !entry.exists()) continue;
            out.printf("  %-30s 0x%08x %8d bytes%n", new Object[]{type, entry.getVirtualAddress(), entry.getSize()});
        }
        out.println();
        out.println("Sections");
        out.println("      Name     Virtual Size  Virtual Address  Raw Data Size  Raw Data Ptr  Characteristics");
        List<Section> sections = this.getSections();
        for (int i = 0; i < sections.size(); ++i) {
            Section section = sections.get(i);
            out.printf("  #%d  %-8s     %8d       0x%08x       %8d    0x%08x  %s%n", i + 1, section.getName(), section.getVirtualSize(), section.getVirtualAddress(), section.getSizeOfRawData(), section.getPointerToRawData(), section.getCharacteristics());
        }
        out.println();
        List<CMSSignedData> signatures = this.getSignatures();
        if (!signatures.isEmpty()) {
            out.println("Signatures");
            for (CMSSignedData signedData : signatures) {
                SignerInformation signerInformation = signedData.getSignerInfos().getSigners().iterator().next();
                X509CertificateHolder certificate = signedData.getCertificates().getMatches(signerInformation.getSID()).iterator().next();
                String commonName = certificate.getSubject().getRDNs(X509ObjectIdentifiers.commonName)[0].getFirst().getValue().toString();
                AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
                boolean timestamped = unsignedAttributes != null && (unsignedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_counterSignature) != null || unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID) != null);
                DigestAlgorithm algorithm = DigestAlgorithm.of(signerInformation.getDigestAlgorithmID().getAlgorithm());
                out.println("  " + commonName + "  " + (algorithm != null ? "[" + algorithm.id + "]  " : "") + (timestamped ? "(timestamped)" : ""));
            }
        }
    }

    @Override
    public synchronized byte[] computeDigest(MessageDigest digest) throws IOException {
        long checksumLocation = this.peHeaderOffset + 88L;
        DataDirectory certificateTable = this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE);
        ChannelUtils.updateDigest(this.channel, digest, 0L, checksumLocation);
        long position = checksumLocation + 4L;
        int certificateTableOffset = this.getDataDirectoryOffset() + 8 * DataDirectoryType.CERTIFICATE_TABLE.ordinal();
        ChannelUtils.updateDigest(this.channel, digest, position, certificateTableOffset);
        position = certificateTableOffset + 8;
        if (certificateTable != null && certificateTable.exists()) {
            certificateTable.check();
            ChannelUtils.updateDigest(this.channel, digest, position, certificateTable.getVirtualAddress());
            position = certificateTable.getVirtualAddress() + (long)certificateTable.getSize();
        }
        ChannelUtils.updateDigest(this.channel, digest, position, this.channel.size());
        if (certificateTable == null || !certificateTable.exists()) {
            int paddingLength = (int)(8L - this.channel.size() % 8L) % 8;
            digest.update(new byte[paddingLength]);
        }
        return digest.digest();
    }

    public byte[] computeDigest(DigestAlgorithm algorithm) throws IOException {
        return this.computeDigest(algorithm.getMessageDigest());
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_PE_IMAGE_DATA_OBJID, new SpcPeImageData());
        return new SpcIndirectDataContent(data, digestInfo);
    }

    public synchronized void pad(int multiple) throws IOException {
        long padding = ((long)multiple - this.channel.size() % (long)multiple) % (long)multiple;
        this.channel.position(this.channel.size());
        this.channel.write(ByteBuffer.allocate((int)padding));
    }
}

