/*
 * Decompiled with CFR 0.152.
 */
package io.kaitai.struct;

import io.kaitai.struct.KaitaiStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ByteBufferKaitaiStream
extends KaitaiStream {
    private FileChannel fc;
    private ByteBuffer bb;

    public ByteBufferKaitaiStream(String fileName) throws IOException {
        this.fc = FileChannel.open(Paths.get(fileName, new String[0]), StandardOpenOption.READ);
        this.bb = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fc.size());
    }

    public ByteBufferKaitaiStream(byte[] arr) {
        this.fc = null;
        this.bb = ByteBuffer.wrap(arr);
    }

    public ByteBufferKaitaiStream(ByteBuffer buffer) {
        this.fc = null;
        this.bb = buffer;
    }

    public ByteBufferKaitaiStream(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("Java ByteBuffer can't be longer than Integer.MAX_VALUE");
        }
        this.fc = null;
        this.bb = ByteBuffer.allocate((int)size);
    }

    public ByteBuffer asRoBuffer() {
        ByteBuffer retVal = this.bb.asReadOnlyBuffer();
        retVal.rewind();
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        Exception exc = null;
        try {
            if (this.bitsWriteMode) {
                this.writeAlignToByte();
                return;
            }
            this.alignToByte();
            return;
        }
        catch (Exception e) {
            exc = e;
            throw e;
        }
        finally {
            this.bb = null;
            if (this.fc != null) {
                try {
                    this.fc.close();
                }
                catch (IOException e) {
                    if (exc == null) throw e;
                    e.addSuppressed(exc);
                    throw e;
                }
                finally {
                    this.fc = null;
                }
            }
        }
    }

    @Override
    public boolean isEof() {
        return !this.bb.hasRemaining() && (this.bitsWriteMode || this.bitsLeft <= 0);
    }

    @Override
    public void seek(int newPos) {
        if (this.bitsWriteMode) {
            this.writeAlignToByte();
        } else {
            this.alignToByte();
        }
        this.bb.position(newPos);
    }

    @Override
    public void seek(long newPos) {
        if (newPos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java ByteBuffer can't be seeked past Integer.MAX_VALUE");
        }
        this.seek((int)newPos);
    }

    @Override
    public int pos() {
        return this.bb.position() + (this.bitsWriteMode && this.bitsLeft > 0 ? 1 : 0);
    }

    @Override
    public long size() {
        return this.bb.limit();
    }

    @Override
    public byte readS1() {
        this.alignToByte();
        return this.bb.get();
    }

    @Override
    public short readS2be() {
        this.alignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getShort();
    }

    @Override
    public int readS4be() {
        this.alignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getInt();
    }

    @Override
    public long readS8be() {
        this.alignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getLong();
    }

    @Override
    public short readS2le() {
        this.alignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getShort();
    }

    @Override
    public int readS4le() {
        this.alignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getInt();
    }

    @Override
    public long readS8le() {
        this.alignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getLong();
    }

    @Override
    public int readU1() {
        this.alignToByte();
        return this.bb.get() & 0xFF;
    }

    @Override
    public int readU2be() {
        this.alignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getShort() & 0xFFFF;
    }

    @Override
    public long readU4be() {
        this.alignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return (long)this.bb.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public int readU2le() {
        this.alignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getShort() & 0xFFFF;
    }

    @Override
    public long readU4le() {
        this.alignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return (long)this.bb.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public float readF4be() {
        this.alignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getFloat();
    }

    @Override
    public double readF8be() {
        this.alignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        return this.bb.getDouble();
    }

    @Override
    public float readF4le() {
        this.alignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getFloat();
    }

    @Override
    public double readF8le() {
        this.alignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        return this.bb.getDouble();
    }

    @Override
    protected byte[] readBytesNotAligned(long n) {
        byte[] buf = new byte[this.toByteArrayLength(n)];
        this.bb.get(buf);
        return buf;
    }

    @Override
    public byte[] readBytesFull() {
        this.alignToByte();
        byte[] buf = new byte[this.bb.remaining()];
        this.bb.get(buf);
        return buf;
    }

    @Override
    public byte[] readBytesTerm(byte term, boolean includeTerm, boolean consumeTerm, boolean eosError) {
        this.alignToByte();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while (true) {
            if (!this.bb.hasRemaining()) {
                if (eosError) {
                    throw new RuntimeException("End of stream reached, but no terminator " + term + " found");
                }
                return buf.toByteArray();
            }
            byte c = this.bb.get();
            if (c == term) {
                if (includeTerm) {
                    buf.write(c);
                }
                if (!consumeTerm) {
                    this.bb.position(this.bb.position() - 1);
                }
                return buf.toByteArray();
            }
            buf.write(c);
        }
    }

    @Override
    public KaitaiStream substream(long n) {
        if (n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java ByteBuffer can't be limited beyond Integer.MAX_VALUE");
        }
        ByteBuffer newBuffer = this.bb.slice();
        newBuffer.limit((int)n);
        this.bb.position(this.bb.position() + (int)n);
        return new ByteBufferKaitaiStream(newBuffer);
    }

    @Override
    public void writeS1(byte v) {
        this.writeAlignToByte();
        this.bb.put(v);
    }

    @Override
    public void writeS2be(short v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putShort(v);
    }

    @Override
    public void writeS4be(int v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putInt(v);
    }

    @Override
    public void writeS8be(long v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putLong(v);
    }

    @Override
    public void writeS2le(short v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putShort(v);
    }

    @Override
    public void writeS4le(int v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putInt(v);
    }

    @Override
    public void writeS8le(long v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putLong(v);
    }

    @Override
    public void writeF4be(float v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putFloat(v);
    }

    @Override
    public void writeF8be(double v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.BIG_ENDIAN);
        this.bb.putDouble(v);
    }

    @Override
    public void writeF4le(float v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putFloat(v);
    }

    @Override
    public void writeF8le(double v) {
        this.writeAlignToByte();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.bb.putDouble(v);
    }

    @Override
    protected void writeBytesNotAligned(byte[] buf) {
        this.bb.put(buf);
    }
}

