/*
 * Decompiled with CFR 0.152.
 */
package io.kaitai.struct;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileKaitaiStream
extends KaitaiStream {
    protected RandomAccessFile raf;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public RandomAccessFileKaitaiStream(String fileName) throws IOException {
        this.raf = new RandomAccessFile(fileName, "r");
    }

    public RandomAccessFileKaitaiStream(RandomAccessFile raf) {
        this.raf = raf;
    }

    @Override
    public void close() throws IOException {
        Exception exc = null;
        try {
            if (this.bitsWriteMode) {
                this.writeAlignToByte();
            } else {
                this.alignToByte();
            }
        }
        catch (Exception e) {
            exc = e;
            throw e;
        }
        finally {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                if (exc != null) {
                    e.addSuppressed(exc);
                }
                throw e;
            }
        }
    }

    @Override
    public boolean isEof() {
        try {
            return this.raf.getFilePointer() >= this.raf.length() && (this.bitsWriteMode || this.bitsLeft <= 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seek(int newPos) {
        this.seek((long)newPos);
    }

    @Override
    public void seek(long newPos) {
        if (this.bitsWriteMode) {
            this.writeAlignToByte();
        } else {
            this.alignToByte();
        }
        try {
            this.raf.seek(newPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int pos() {
        try {
            return (int)this.raf.getFilePointer() + (this.bitsWriteMode && this.bitsLeft > 0 ? 1 : 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long size() {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readS1() {
        this.alignToByte();
        try {
            int t = this.raf.read();
            if (t < 0) {
                throw new EOFException();
            }
            return (byte)t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readS2be() {
        this.alignToByte();
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (short)((b1 << 8) + (b2 << 0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readS4be() {
        this.alignToByte();
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            int b3 = this.raf.read();
            int b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0) {
                throw new EOFException();
            }
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readS8be() {
        this.alignToByte();
        long b1 = this.readU4be();
        long b2 = this.readU4be();
        return (b1 << 32) + (b2 << 0);
    }

    @Override
    public short readS2le() {
        this.alignToByte();
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (short)((b2 << 8) + (b1 << 0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readS4le() {
        this.alignToByte();
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            int b3 = this.raf.read();
            int b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0) {
                throw new EOFException();
            }
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readS8le() {
        this.alignToByte();
        long b1 = this.readU4le();
        long b2 = this.readU4le();
        return (b2 << 32) + (b1 << 0);
    }

    @Override
    public int readU1() {
        this.alignToByte();
        try {
            int t = this.raf.read();
            if (t < 0) {
                throw new EOFException();
            }
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readU2be() {
        this.alignToByte();
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (b1 << 8) + (b2 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readU4be() {
        this.alignToByte();
        try {
            long b1 = this.raf.read();
            long b2 = this.raf.read();
            long b3 = this.raf.read();
            long b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0L) {
                throw new EOFException();
            }
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readU2le() {
        this.alignToByte();
        try {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            if ((b1 | b2) < 0) {
                throw new EOFException();
            }
            return (b2 << 8) + (b1 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readU4le() {
        this.alignToByte();
        try {
            long b1 = this.raf.read();
            long b2 = this.raf.read();
            long b3 = this.raf.read();
            long b4 = this.raf.read();
            if ((b1 | b2 | b3 | b4) < 0L) {
                throw new EOFException();
            }
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readF4be() {
        return Float.intBitsToFloat(this.readS4be());
    }

    @Override
    public double readF8be() {
        return Double.longBitsToDouble(this.readS8be());
    }

    @Override
    public float readF4le() {
        return Float.intBitsToFloat(this.readS4le());
    }

    @Override
    public double readF8le() {
        return Double.longBitsToDouble(this.readS8le());
    }

    @Override
    protected byte[] readBytesNotAligned(long n) {
        byte[] buf = new byte[this.toByteArrayLength(n)];
        try {
            int readCount = this.raf.read(buf);
            if ((long)readCount < n) {
                throw new EOFException();
            }
            return buf;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] readBytesFull() {
        this.alignToByte();
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int readCount;
            while (-1 != (readCount = this.raf.read(buffer))) {
                baos.write(buffer, 0, readCount);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] readBytesTerm(byte term, boolean includeTerm, boolean consumeTerm, boolean eosError) {
        this.alignToByte();
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            while (true) {
                int c;
                if ((c = this.raf.read()) < 0) {
                    if (eosError) {
                        throw new RuntimeException("End of stream reached, but no terminator " + term + " found");
                    }
                    return buf.toByteArray();
                }
                if ((byte)c == term) {
                    if (includeTerm) {
                        buf.write(c);
                    }
                    if (!consumeTerm) {
                        this.raf.seek(this.raf.getFilePointer() - 1L);
                    }
                    return buf.toByteArray();
                }
                buf.write(c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public KaitaiStream substream(long n) {
        return new ByteBufferKaitaiStream(this.readBytes(n));
    }

    protected void ensureBytesLeftToWrite(long n) throws IOException {
        this.ensureBytesLeftToWrite(n, this.raf.getFilePointer());
    }

    @Override
    public void writeS1(byte v) {
        this.writeAlignToByte();
        try {
            this.ensureBytesLeftToWrite(1L);
            this.raf.write(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeS2be(short v) {
        this.writeAlignToByte();
        try {
            this.ensureBytesLeftToWrite(2L);
            this.raf.write(v >>> 8 & 0xFF);
            this.raf.write(v >>> 0 & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeS4be(int v) {
        this.writeAlignToByte();
        try {
            this.ensureBytesLeftToWrite(4L);
            this.raf.write(v >>> 24 & 0xFF);
            this.raf.write(v >>> 16 & 0xFF);
            this.raf.write(v >>> 8 & 0xFF);
            this.raf.write(v >>> 0 & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeS8be(long v) {
        this.writeAlignToByte();
        try {
            this.ensureBytesLeftToWrite(8L);
            this.raf.write((int)(v >>> 56) & 0xFF);
            this.raf.write((int)(v >>> 48) & 0xFF);
            this.raf.write((int)(v >>> 40) & 0xFF);
            this.raf.write((int)(v >>> 32) & 0xFF);
            this.raf.write((int)(v >>> 24) & 0xFF);
            this.raf.write((int)(v >>> 16) & 0xFF);
            this.raf.write((int)(v >>> 8) & 0xFF);
            this.raf.write((int)(v >>> 0) & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeS2le(short v) {
        this.writeAlignToByte();
        try {
            this.ensureBytesLeftToWrite(2L);
            this.raf.write(v >>> 0 & 0xFF);
            this.raf.write(v >>> 8 & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeS4le(int v) {
        this.writeAlignToByte();
        try {
            this.ensureBytesLeftToWrite(4L);
            this.raf.write(v >>> 0 & 0xFF);
            this.raf.write(v >>> 8 & 0xFF);
            this.raf.write(v >>> 16 & 0xFF);
            this.raf.write(v >>> 24 & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeS8le(long v) {
        this.writeAlignToByte();
        try {
            this.ensureBytesLeftToWrite(8L);
            this.raf.write((int)(v >>> 0) & 0xFF);
            this.raf.write((int)(v >>> 8) & 0xFF);
            this.raf.write((int)(v >>> 16) & 0xFF);
            this.raf.write((int)(v >>> 24) & 0xFF);
            this.raf.write((int)(v >>> 32) & 0xFF);
            this.raf.write((int)(v >>> 40) & 0xFF);
            this.raf.write((int)(v >>> 48) & 0xFF);
            this.raf.write((int)(v >>> 56) & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeF4be(float v) {
        this.writeS4be(Float.floatToIntBits(v));
    }

    @Override
    public void writeF8be(double v) {
        this.writeS8be(Double.doubleToLongBits(v));
    }

    @Override
    public void writeF4le(float v) {
        this.writeS4le(Float.floatToIntBits(v));
    }

    @Override
    public void writeF8le(double v) {
        this.writeS8le(Double.doubleToLongBits(v));
    }

    @Override
    protected void writeBytesNotAligned(byte[] buf) {
        try {
            this.ensureBytesLeftToWrite(buf.length);
            this.raf.write(buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

