/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.animation;

import com.github.ajalt.mordant.animation.ProgressHistoryEntry;
import com.github.ajalt.mordant.internal.FormattingKt;
import com.github.ajalt.mordant.widgets.ProgressState;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020\u001bJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0006R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/github/ajalt/mordant/animation/ProgressHistory;", "", "windowLengthSeconds", "", "timeSource", "Lkotlin/Function0;", "", "(FLkotlin/jvm/functions/Function0;)V", "completed", "getCompleted", "()J", "completedPerSecond", "", "getCompletedPerSecond", "()D", "elapsedSeconds", "getElapsedSeconds", "samples", "Lkotlin/collections/ArrayDeque;", "Lcom/github/ajalt/mordant/animation/ProgressHistoryEntry;", "startTime", "started", "", "getStarted", "()Z", "windowLengthNs", "clear", "", "makeState", "Lcom/github/ajalt/mordant/widgets/ProgressState;", "total", "(Ljava/lang/Long;)Lcom/github/ajalt/mordant/widgets/ProgressState;", "start", "update", "mordant"})
final class ProgressHistory {
    @NotNull
    private final Function0<Long> timeSource;
    private long startTime;
    @NotNull
    private final ArrayDeque<ProgressHistoryEntry> samples;
    private final long windowLengthNs;

    public ProgressHistory(float windowLengthSeconds, @NotNull Function0<Long> timeSource2) {
        Intrinsics.checkNotNullParameter(timeSource2, (String)"timeSource");
        this.timeSource = timeSource2;
        this.startTime = -1L;
        this.samples = new ArrayDeque();
        this.windowLengthNs = (long)((float)TimeUnit.SECONDS.toNanos(1L) * windowLengthSeconds);
    }

    public final void start() {
        if (!this.getStarted()) {
            this.startTime = ((Number)this.timeSource.invoke()).longValue();
        }
    }

    public final void clear() {
        this.startTime = -1L;
        this.samples.clear();
    }

    public final void update(long completed) {
        this.start();
        long now = ((Number)this.timeSource.invoke()).longValue();
        long keepTime = now - this.windowLengthNs;
        while (true) {
            ProgressHistoryEntry it = (ProgressHistoryEntry)this.samples.firstOrNull();
            boolean bl = false;
            if (!(it != null && it.getTimeNs() < keepTime)) break;
            this.samples.removeFirst();
        }
        this.samples.addLast((Object)new ProgressHistoryEntry(now, completed));
    }

    @NotNull
    public final ProgressState makeState(@Nullable Long total) {
        return new ProgressState(this.getCompleted(), total, this.getCompletedPerSecond(), this.getElapsedSeconds());
    }

    public final boolean getStarted() {
        return this.startTime >= 0L;
    }

    public final long getCompleted() {
        long l;
        ProgressHistoryEntry progressHistoryEntry = (ProgressHistoryEntry)this.samples.lastOrNull();
        return progressHistoryEntry == null ? 0L : (l = progressHistoryEntry.getCompleted());
    }

    private final double getElapsedSeconds() {
        return this.startTime >= 0L ? FormattingKt.nanosToSeconds(((Number)this.timeSource.invoke()).longValue() - this.startTime) : 0.0;
    }

    private final double getCompletedPerSecond() {
        if (this.startTime < 0L || this.samples.size() < 2) {
            return 0.0;
        }
        double sampleTimespan = FormattingKt.nanosToSeconds(((ProgressHistoryEntry)this.samples.last()).getTimeNs() - ((ProgressHistoryEntry)this.samples.first()).getTimeNs());
        long complete = ((ProgressHistoryEntry)this.samples.last()).getCompleted() - ((ProgressHistoryEntry)this.samples.first()).getCompleted();
        return complete <= 0L || sampleTimespan <= 0.0 ? 0.0 : (double)complete / sampleTimespan;
    }
}

