/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.mordant.internal.AnsiCodes;
import com.github.ajalt.mordant.internal.Chunk;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.TxtStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\u001a,\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002\u001a \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\rH\u0000\u001a \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LS", "", "NEL", "getAnsiColor", "Lkotlin/Pair;", "Lcom/github/ajalt/colormath/Color;", "", "i", "codes", "", "parseAnsi", "Lcom/github/ajalt/mordant/internal/Chunk;", "text", "", "defaultStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "parseText", "Lcom/github/ajalt/mordant/rendering/Lines;", "style", "splitLines", "Lcom/github/ajalt/mordant/rendering/Line;", "words", "", "splitWords", "chunk", "updateStyle", "existingStyle", "ansi", "updateStyleWithCsi", "updateStyleWithOsc", "mordant"})
public final class ParsingKt {
    private static final char NEL = '\u0085';
    private static final char LS = '\u2028';

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Lines parseText(@NotNull String text, @NotNull TextStyle style) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        List<Chunk> parseAnsi = ParsingKt.parseAnsi(text, style);
        Iterable $this$flatMap$iv = parseAnsi;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ParsingKt.splitWords(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List words = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        List<Line> splitLines = ParsingKt.splitLines(words);
        return new Lines(splitLines);
    }

    private static final List<Chunk> parseAnsi(String text, TextStyle defaultStyle) {
        Object object;
        List commands = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)ConstantsKt.getANSI_RE(), (CharSequence)text, (int)0, (int)2, null));
        if (commands.isEmpty()) {
            return CollectionsKt.listOf((Object)new Chunk(text, defaultStyle));
        }
        List parts = new ArrayList();
        int idxAfterLastCmd = 0;
        TextStyle style = defaultStyle;
        for (MatchResult command : commands) {
            if (command.getRange().getFirst() > idxAfterLastCmd) {
                object = parts;
                Object object2 = text;
                int n = command.getRange().getFirst();
                String string = ((String)object2).substring(idxAfterLastCmd, n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object2 = new Chunk(string, style);
                object.add(object2);
            }
            idxAfterLastCmd = command.getRange().getLast() + 1;
            style = ParsingKt.updateStyle(style, defaultStyle, command.getValue());
        }
        if (idxAfterLastCmd < text.length()) {
            Collection collection = parts;
            object = text.substring(idxAfterLastCmd);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
            Chunk chunk = new Chunk((String)object, style);
            collection.add(chunk);
        }
        return parts;
    }

    private static final List<Chunk> splitWords(Chunk chunk) {
        Object object;
        int i;
        List chunks = new ArrayList();
        int start2 = 0;
        int chunkType = -1;
        String t = chunk.getText();
        for (i = 0; i < t.length(); ++i) {
            int type;
            char c = t.charAt(i);
            int n = c == '\r' ? 0 : (c == '\n' || c == '\t' || c == '\u0085' || c == '\u2028' ? 1 : (type = CharsKt.isWhitespace((char)c) ? 2 : 3));
            if (i == 0) {
                chunkType = type;
                continue;
            }
            if (type != 1 && chunkType == type) continue;
            object = chunks;
            String string = t.substring(start2, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Chunk chunk2 = Chunk.copy$default(chunk, string, null, 2, null);
            object.add(chunk2);
            start2 = i;
            chunkType = type;
        }
        if (start2 != i) {
            Collection collection = chunks;
            object = t.substring(start2, i);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Chunk chunk3 = Chunk.copy$default(chunk, (String)object, null, 2, null);
            collection.add(chunk3);
        }
        return chunks;
    }

    private static final List<Line> splitLines(Iterable<Chunk> words) {
        List lines = new ArrayList();
        List line = new ArrayList();
        for (Chunk word : words) {
            if (StringsKt.endsWith$default((String)word.getText(), (String)"\n", (boolean)false, (int)2, null)) {
                ((Collection)lines).add(new Line(line, word.getStyle()));
                line = new ArrayList();
                continue;
            }
            line.add(Span.Companion.word(word.getText(), word.getStyle()));
        }
        if (!((Collection)line).isEmpty()) {
            ((Collection)lines).add(new Line(line));
        }
        return lines;
    }

    @NotNull
    public static final TextStyle updateStyle(@NotNull TextStyle existingStyle, @NotNull TextStyle defaultStyle, @NotNull String ansi) {
        Intrinsics.checkNotNullParameter((Object)existingStyle, (String)"existingStyle");
        Intrinsics.checkNotNullParameter((Object)defaultStyle, (String)"defaultStyle");
        Intrinsics.checkNotNullParameter((Object)ansi, (String)"ansi");
        if (StringsKt.startsWith$default((String)ansi, (String)"\u001b]", (boolean)false, (int)2, null)) {
            return ParsingKt.updateStyleWithOsc(ansi, existingStyle, defaultStyle);
        }
        if (StringsKt.startsWith$default((String)ansi, (String)"\u001b[", (boolean)false, (int)2, null)) {
            return ParsingKt.updateStyleWithCsi(ansi, existingStyle, defaultStyle);
        }
        return existingStyle;
    }

    private static final TextStyle updateStyleWithOsc(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        String string;
        String id;
        String string2;
        if (!StringsKt.startsWith$default((String)ansi, (String)"\u001b]8", (boolean)false, (int)2, null)) {
            return existingStyle;
        }
        String string3 = ansi.substring(3, ansi.length() - 2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String[] stringArray = new String[]{";"};
        List params = StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (params.isEmpty()) {
            return existingStyle;
        }
        Object object = CollectionsKt.last((List)params);
        String it = (String)object;
        boolean bl = false;
        String hyperlink = (String)(!StringsKt.isBlank((CharSequence)it) ? object : null);
        if (hyperlink == null) {
            string2 = defaultStyle.getHyperlinkId();
        } else {
            Object v1;
            block6: {
                for (Object t : (Iterable)params) {
                    String it2 = (String)t;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)"id=", (boolean)false, (int)2, null)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            String string4 = v1;
            string2 = id = string4 == null ? null : StringsKt.drop((String)string4, (int)3);
        }
        if ((string = hyperlink) == null) {
            string = defaultStyle.getHyperlink();
        }
        return TextStyleKt.copy$default(existingStyle, null, null, string, id, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextStyle updateStyleWithCsi(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        void $this$mapNotNullTo$iv$iv;
        if (!StringsKt.endsWith$default((String)ansi, (String)"m", (boolean)false, (int)2, null)) {
            return existingStyle;
        }
        String[] stringArray = new String[]{";"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)ansi.subSequence(2, ansi.length() - 1), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((((CharSequence)it).length() == 0 ? Integer.valueOf(0) : StringsKt.toIntOrNull((String)it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List codes = (List)destination$iv$iv;
        if (codes.isEmpty()) {
            return defaultStyle;
        }
        Color color = existingStyle.getColor();
        Color bgColor = existingStyle.getBgColor();
        boolean bold = existingStyle.getBold();
        boolean italic = existingStyle.getItalic();
        boolean underline = existingStyle.getUnderline();
        boolean dim = existingStyle.getDim();
        boolean inverse = existingStyle.getInverse();
        boolean strikethrough = existingStyle.getStrikethrough();
        for (int i = 0; i <= CollectionsKt.getLastIndex((List)codes); ++i) {
            int n;
            int consumed;
            boolean bl;
            boolean bl4;
            int code = ((Number)codes.get(i)).intValue();
            if (code == 0) {
                color = existingStyle.getColor();
                bgColor = existingStyle.getBgColor();
                bold = existingStyle.getBold();
                italic = existingStyle.getItalic();
                underline = existingStyle.getUnderline();
                dim = existingStyle.getDim();
                inverse = existingStyle.getInverse();
                strikethrough = existingStyle.getStrikethrough();
                continue;
            }
            if (code == 22) {
                bold = defaultStyle.getBold();
                dim = defaultStyle.getDim();
                continue;
            }
            if (code == 23) {
                italic = defaultStyle.getItalic();
                continue;
            }
            if (code == 24) {
                underline = defaultStyle.getUnderline();
                continue;
            }
            if (code == 27) {
                inverse = defaultStyle.getInverse();
                continue;
            }
            if (code == 29) {
                strikethrough = defaultStyle.getStrikethrough();
                continue;
            }
            if (code == 39) {
                color = defaultStyle.getColor();
                continue;
            }
            if (code == 49) {
                bgColor = defaultStyle.getBgColor();
                continue;
            }
            Pair<Color, Integer> pair = AnsiCodes.INSTANCE.getFg16Range();
            int it = pair.getFirst();
            boolean bl5 = code <= pair.getLast() ? it <= code : false;
            if (bl5) {
                bl4 = true;
            } else {
                pair = AnsiCodes.INSTANCE.getFg16BrightRange();
                it = pair.getFirst();
                bl4 = code <= pair.getLast() ? it <= code : false;
            }
            if (bl4) {
                color = (Color)new Ansi16(code);
                continue;
            }
            pair = AnsiCodes.INSTANCE.getBg16Range();
            it = pair.getFirst();
            boolean bl6 = code <= pair.getLast() ? it <= code : false;
            if (bl6) {
                bl = true;
            } else {
                pair = AnsiCodes.INSTANCE.getBg16BrightRange();
                it = pair.getFirst();
                bl = code <= pair.getLast() ? it <= code : false;
            }
            if (bl) {
                bgColor = (Color)new Ansi16(code - 10);
                continue;
            }
            if (code == 38) {
                pair = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = (Color)pair.component1();
                consumed = ((Number)pair.component2()).intValue();
                if (c == null) break;
                color = c;
                i += consumed;
                continue;
            }
            if (code == 48) {
                pair = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = (Color)pair.component1();
                consumed = ((Number)pair.component2()).intValue();
                if (c == null) break;
                bgColor = c;
                i += consumed;
                continue;
            }
            if (code == 1) {
                bold = true;
                continue;
            }
            if (code == 3) {
                italic = true;
                continue;
            }
            if (code == 4) {
                underline = true;
                continue;
            }
            if (code == 2) {
                dim = true;
                continue;
            }
            if (code == 7) {
                inverse = true;
                continue;
            }
            if (code == 9) {
                strikethrough = true;
                continue;
            }
            if (code != 58) continue;
            if (i == CollectionsKt.getLastIndex((List)codes)) {
                n = 0;
            } else {
                Integer n2 = (Integer)CollectionsKt.getOrNull((List)codes, (int)(i + 1));
                int n3 = 5;
                if (n2 != null && n2 == n3) {
                    n = 1;
                } else {
                    Integer n4 = (Integer)CollectionsKt.getOrNull((List)codes, (int)(i + 1));
                    n3 = 2;
                    if (n4 == null || n4 != n3) break;
                    n = 3;
                }
            }
            i = i + n;
        }
        return new TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, existingStyle.getHyperlink(), existingStyle.getHyperlinkId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Pair<Color, Integer> getAnsiColor(int i, List<Integer> codes) {
        Pair pair;
        switch (((Number)codes.get(i)).intValue()) {
            case 5: {
                if (i + 1 <= CollectionsKt.getLastIndex(codes)) {
                    int n = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n ? n < 256 : false;
                    if (bl) {
                        pair = TuplesKt.to((Object)new Ansi256(((Number)codes.get(i + 1)).intValue()), (Object)2);
                        return pair;
                    }
                }
                pair = TuplesKt.to(null, (Object)0);
                return pair;
            }
            case 2: {
                if (i + 3 <= CollectionsKt.getLastIndex(codes)) {
                    int n = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n ? n < 256 : false;
                    if (bl) {
                        n = ((Number)codes.get(i + 2)).intValue();
                        boolean bl2 = 0 <= n ? n < 256 : false;
                        if (bl2) {
                            n = ((Number)codes.get(i + 3)).intValue();
                            boolean bl3 = 0 <= n ? n < 256 : false;
                            if (bl3) {
                                pair = TuplesKt.to((Object)RGBColorSpace.DefaultImpls.from255$default((RGBColorSpace)((RGBColorSpace)RGB.Companion), (int)((Number)codes.get(i + 1)).intValue(), (int)((Number)codes.get(i + 2)).intValue(), (int)((Number)codes.get(i + 3)).intValue(), (int)0, (int)8, null), (Object)4);
                                return pair;
                            }
                        }
                    }
                }
                pair = TuplesKt.to(null, (Object)0);
                return pair;
            }
        }
        pair = TuplesKt.to(null, (Object)0);
        return pair;
    }
}

