/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.rendering;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.VerticalAlign;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0005\u001a\u00020\u00022\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a2\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0012"}, d2={"lineWidth", "", "Lcom/github/ajalt/mordant/rendering/Line;", "getLineWidth", "(Lcom/github/ajalt/mordant/rendering/Line;)I", "flatLine", "parts", "", "", "([Ljava/lang/Object;)Lcom/github/ajalt/mordant/rendering/Line;", "setSize", "Lcom/github/ajalt/mordant/rendering/Lines;", "newWidth", "newHeight", "verticalAlign", "Lcom/github/ajalt/mordant/rendering/VerticalAlign;", "textAlign", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "mordant"})
public final class LinesKt {
    /*
     * WARNING - void declaration
     */
    public static final int getLineWidth(@NotNull Line $this$lineWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$lineWidth, (String)"<this>");
        Iterable iterable = $this$lineWidth.getSpans();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Span span = (Span)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getCellWidth$mordant();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Line flatLine(Object ... parts) {
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        Object[] objectArray = parts;
        int n = 0;
        for (Object object : objectArray) {
            void it;
            Object object2 = object;
            int n2 = n;
            boolean bl = false;
            int n3 = it instanceof Collection ? ((Collection)it).size() : 1;
            n = n2 + n3;
        }
        int size = n;
        ArrayList<Object> line = new ArrayList<Object>(size);
        n = 0;
        int n4 = parts.length;
        while (n < n4) {
            Object part = parts[n];
            ++n;
            Object object = part;
            if (object == null) continue;
            if (object instanceof Collection) {
                Iterable $this$mapTo$iv = (Iterable)part;
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv;
                    Object t = item$iv = iterator.next();
                    Collection collection = line;
                    boolean bl = false;
                    void v0 = it;
                    if (v0 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.github.ajalt.mordant.rendering.Span");
                    }
                    collection.add((Span)v0);
                }
                continue;
            }
            if (object instanceof Span) {
                line.add(part);
                continue;
            }
            throw new IllegalStateException(Intrinsics.stringPlus((String)"not a span: ", (Object)part).toString());
        }
        return new Line((List<Span>)line);
    }

    @NotNull
    public static final Lines setSize(@NotNull Lines $this$setSize, int newWidth, int newHeight, @NotNull VerticalAlign verticalAlign2, @NotNull TextAlign textAlign2) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$setSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign2), (String)"verticalAlign");
        Intrinsics.checkNotNullParameter((Object)((Object)textAlign2), (String)"textAlign");
        if (newHeight == 0) {
            return ConstantsKt.getEMPTY_LINES();
        }
        if (newWidth == 0) {
            ArrayList<Line> arrayList = new ArrayList<Line>(newHeight);
            int n3 = 0;
            while (n3 < newHeight) {
                int n4;
                int n5;
                int n6 = n5 = (n4 = n3++);
                ArrayList<Line> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(ConstantsKt.getEMPTY_LINE());
            }
            List list = arrayList;
            return new Lines(list);
        }
        int heightToAdd = RangesKt.coerceAtLeast((int)(newHeight - $this$setSize.getLines().size()), (int)0);
        Line emptyLine = new Line(CollectionsKt.listOf((Object)Span.Companion.space$default(Span.Companion, newWidth, null, 2, null)));
        ArrayList<Line> lines = new ArrayList<Line>(newHeight);
        switch (WhenMappings.$EnumSwitchMapping$0[verticalAlign2.ordinal()]) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = heightToAdd / 2 + heightToAdd % 2;
                break;
            }
            case 3: {
                n2 = heightToAdd;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int topEmptyLines = n2;
        int it22 = 0;
        while (it22 < topEmptyLines) {
            int it = n = it22++;
            boolean bl = false;
            lines.add(emptyLine);
        }
        Iterator<Line> it22 = $this$setSize.getLines().iterator();
        n = 0;
        block13: while (it22.hasNext()) {
            int i = n++;
            Line line = it22.next();
            if (i >= newHeight) break;
            int width = 0;
            Iterator<Span> iterator = line.iterator();
            int n7 = 0;
            while (iterator.hasNext()) {
                int j = n7++;
                Span span = iterator.next();
                if (width + span.getCellWidth$mordant() <= newWidth) {
                    width += span.getCellWidth$mordant();
                    continue;
                }
                if (width == newWidth) {
                    lines.add(new Line(line.subList(0, j)));
                    continue block13;
                }
                lines.add(new Line(CollectionsKt.plus((Collection)line.subList(0, j), (Object)span.take$mordant(newWidth - width))));
                continue block13;
            }
            int remainingWidth = newWidth - width;
            if (remainingWidth > 0) {
                Span span = (Span)CollectionsKt.firstOrNull((List)line);
                TextStyle textStyle = span == null ? null : span.getStyle();
                if (textStyle == null) {
                    textStyle = line.getEndStyle();
                }
                TextStyle beginStyle = textStyle;
                TextStyle endStyle = line.getEndStyle();
                switch (WhenMappings.$EnumSwitchMapping$1[textAlign2.ordinal()]) {
                    case 1: 
                    case 2: {
                        Span l = Span.Companion.space(remainingWidth / 2, beginStyle);
                        Span r = Span.Companion.space(remainingWidth / 2 + remainingWidth % 2, endStyle);
                        Object[] objectArray = new List[]{CollectionsKt.listOf((Object)l), line, CollectionsKt.listOf((Object)r)};
                        lines.add(new Line(CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray))));
                        break;
                    }
                    case 3: {
                        lines.add(new Line(CollectionsKt.plus((Collection)line, (Object)Span.Companion.space(remainingWidth, endStyle))));
                        break;
                    }
                    case 4: {
                        lines.add(new Line(CollectionsKt.plus((Collection)line, (Object)Span.Companion.space$default(Span.Companion, remainingWidth, null, 2, null))));
                        break;
                    }
                    case 5: {
                        lines.add(new Line(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)Span.Companion.space(remainingWidth, beginStyle)), (Iterable)line)));
                    }
                }
                continue;
            }
            lines.add(line);
        }
        if (newHeight != lines.size()) {
            if (newHeight < lines.size()) {
                return new Lines(CollectionsKt.take((Iterable)lines, (int)newHeight));
            }
            Line line = newWidth == 0 ? ConstantsKt.getEMPTY_LINE() : new Line(CollectionsKt.listOf((Object)Span.Companion.space$default(Span.Companion, newWidth, null, 2, null)));
            n = newHeight - lines.size();
            int n8 = 0;
            while (n8 < n) {
                int n9;
                int it = n9 = n8++;
                boolean bl = false;
                lines.add(line);
            }
        }
        return new Lines((List<Line>)lines);
    }

    public static /* synthetic */ Lines setSize$default(Lines lines, int n, int n2, VerticalAlign verticalAlign2, TextAlign textAlign2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = lines.getLines().size();
        }
        if ((n3 & 4) != 0) {
            verticalAlign2 = VerticalAlign.TOP;
        }
        if ((n3 & 8) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        return LinesKt.setSize(lines, n, n2, verticalAlign2, textAlign2);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VerticalAlign.values().length];
            nArray[VerticalAlign.TOP.ordinal()] = 1;
            nArray[VerticalAlign.MIDDLE.ordinal()] = 2;
            nArray[VerticalAlign.BOTTOM.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextAlign.values().length];
            nArray[TextAlign.CENTER.ordinal()] = 1;
            nArray[TextAlign.JUSTIFY.ordinal()] = 2;
            nArray[TextAlign.LEFT.ordinal()] = 3;
            nArray[TextAlign.NONE.ordinal()] = 4;
            nArray[TextAlign.RIGHT.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

