/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.rendering;

import com.github.ajalt.mordant.internal.CellwidthKt;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.TextStyle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001cR\u001b\u0010\u0007\u001a\u00020\b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/github/ajalt/mordant/rendering/Span;", "", "text", "", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "cellWidth", "", "getCellWidth$mordant", "()I", "cellWidth$delegate", "Lkotlin/Lazy;", "getStyle", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "getText", "()Ljava/lang/String;", "isTab", "", "isTab$mordant", "isWhitespace", "isWhitespace$mordant", "replaceStyle", "replaceStyle$mordant", "take", "n", "take$mordant", "withStyle", "withStyle$mordant", "Companion", "mordant"})
public final class Span {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final TextStyle style;
    @NotNull
    private final Lazy cellWidth$delegate;

    private Span(String text, TextStyle style) {
        this.text = text;
        this.style = style;
        this.cellWidth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Span this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return CellwidthKt.stringCellWidth(this.this$0.getText());
            }
        }));
    }

    /* synthetic */ Span(String string, TextStyle textStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textStyle = ConstantsKt.getDEFAULT_STYLE();
        }
        this(string, textStyle);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getCellWidth$mordant() {
        Lazy lazy = this.cellWidth$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final Span take$mordant(int n) {
        return new Span(StringsKt.take((String)this.text, (int)n), this.style);
    }

    public final boolean isWhitespace$mordant() {
        return CharsKt.isWhitespace((char)this.text.charAt(0));
    }

    public final boolean isTab$mordant() {
        return this.text.charAt(0) == '\t';
    }

    @NotNull
    public final Span withStyle$mordant(@NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return new Span(this.text, this.style.plus(style));
    }

    @NotNull
    public final Span replaceStyle$mordant(@NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return new Span(this.text, style);
    }

    public /* synthetic */ Span(String text, TextStyle style, DefaultConstructorMarker $constructor_marker) {
        this(text, style);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/github/ajalt/mordant/rendering/Span$Companion;", "", "()V", "raw", "Lcom/github/ajalt/mordant/rendering/Span;", "text", "", "space", "width", "", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "word", "mordant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Span word(@NotNull String text, @NotNull TextStyle style) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            if (!(((CharSequence)text).length() > 0)) {
                boolean $i$a$-require-Span$Companion$word$22 = false;
                String $i$a$-require-Span$Companion$word$22 = "Span text cannot be empty";
                throw new IllegalArgumentException($i$a$-require-Span$Companion$word$22.toString());
            }
            CharSequence $this$count$iv = text;
            boolean $i$f$count = false;
            int count$iv = 0;
            CharSequence charSequence = $this$count$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) continue;
                ++count$iv;
            }
            int it = count$iv;
            boolean bl = false;
            if (!(it == 0 || it == text.length())) {
                boolean $i$a$-require-Span$Companion$word$72 = false;
                String $i$a$-require-Span$Companion$word$72 = "Spans must contain ether all whitespace, or no whitespace: \"" + text + '\"';
                throw new IllegalArgumentException($i$a$-require-Span$Companion$word$72.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)text, (CharSequence)"\n", (boolean)false, (int)2, null))) {
                boolean $i$a$-require-Span$Companion$word$82 = false;
                String $i$a$-require-Span$Companion$word$82 = "Spans cannot contain newlines";
                throw new IllegalArgumentException($i$a$-require-Span$Companion$word$82.toString());
            }
            if (!(!StringsKt.contains$default((CharSequence)text, (CharSequence)"\u001b[", (boolean)false, (int)2, null))) {
                boolean bl2 = false;
                String string = "Spans cannot contain ANSI codes";
                throw new IllegalArgumentException(string.toString());
            }
            return new Span(text, style, null);
        }

        public static /* synthetic */ Span word$default(Companion companion, String string, TextStyle textStyle, int n, Object object) {
            if ((n & 2) != 0) {
                textStyle = ConstantsKt.getDEFAULT_STYLE();
            }
            return companion.word(string, textStyle);
        }

        @NotNull
        public final Span space(int width, @NotNull TextStyle style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            return new Span(StringsKt.repeat((CharSequence)" ", (int)width), style, null);
        }

        public static /* synthetic */ Span space$default(Companion companion, int n, TextStyle textStyle, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            if ((n2 & 2) != 0) {
                textStyle = ConstantsKt.getDEFAULT_STYLE();
            }
            return companion.space(n, textStyle);
        }

        @NotNull
        public final Span raw(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Span(text, ConstantsKt.getDEFAULT_STYLE(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

