/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.terminal.CursorMovements;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lcom/github/ajalt/mordant/terminal/AnsiMovements;", "Lcom/github/ajalt/mordant/terminal/CursorMovements;", "()V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "output", "", "getOutput", "()Ljava/lang/String;", "clearLine", "", "clearLineAfterCursor", "clearLineBeforeCursor", "clearScreen", "clearScreenAfterCursor", "clearScreenBeforeCursor", "csi", "command", "down", "count", "", "left", "print", "kotlin.jvm.PlatformType", "text", "restorePosition", "right", "savePosition", "setPosition", "x", "y", "startOfLine", "up", "mordant"})
final class AnsiMovements
implements CursorMovements {
    @NotNull
    private final StringBuilder builder = new StringBuilder();

    @NotNull
    public final String getOutput() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @Override
    public void up(int count) {
        if (count < 0) {
            this.down(-count);
        } else if (count > 0) {
            this.csi("" + count + 'A');
        }
    }

    @Override
    public void down(int count) {
        if (count < 0) {
            this.up(-count);
        } else if (count > 0) {
            this.csi("" + count + 'B');
        }
    }

    @Override
    public void right(int count) {
        if (count < 0) {
            this.left(-count);
        } else if (count > 0) {
            this.csi("" + count + 'C');
        }
    }

    @Override
    public void left(int count) {
        if (count < 0) {
            this.right(-count);
        } else if (count > 0) {
            this.csi("" + count + 'D');
        }
    }

    @Override
    public void startOfLine() {
        this.print("\r");
    }

    @Override
    public void setPosition(int x, int y) {
        if (!(x >= 0)) {
            boolean $i$a$-require-AnsiMovements$setPosition$32 = false;
            String $i$a$-require-AnsiMovements$setPosition$32 = "Invalid cursor column " + x + "; value cannot be negative";
            throw new IllegalArgumentException($i$a$-require-AnsiMovements$setPosition$32.toString());
        }
        if (!(y >= 0)) {
            boolean bl = false;
            String string = "Invalid cursor column " + y + "; value cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.csi("" + (y + 1) + ';' + (x + 1) + 'H');
    }

    @Override
    public void clearScreen() {
        this.csi("2J");
    }

    @Override
    public void clearScreenAfterCursor() {
        this.csi("0J");
    }

    @Override
    public void clearScreenBeforeCursor() {
        this.csi("1J");
    }

    @Override
    public void clearLineAfterCursor() {
        this.csi("0K");
    }

    @Override
    public void clearLineBeforeCursor() {
        this.csi("1K");
    }

    @Override
    public void clearLine() {
        this.csi("2K");
    }

    @Override
    public void savePosition() {
        this.csi("s");
    }

    @Override
    public void restorePosition() {
        this.csi("u");
    }

    private final void csi(String command) {
        this.print(Intrinsics.stringPlus((String)"\u001b[", (Object)command));
    }

    private final StringBuilder print(String text) {
        return this.builder.append(text);
    }
}

