/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.AnsiRenderKt;
import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.terminal.DisabledTerminalCursor;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.StdoutTerminalInterface;
import com.github.ajalt.mordant.terminal.TerminalColors;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BW\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rB#\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b(J?\u0010)\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u00020\u0000J?\u0010\u0019\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00101J?\u00103\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00101J\u000e\u00104\u001a\u00020&2\u0006\u00105\u001a\u000206J?\u00104\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00101J\u0006\u00107\u001a\u00020&J\u000e\u00107\u001a\u00020&2\u0006\u00105\u001a\u000206J?\u00107\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00101J\u0010\u00108\u001a\u00020&2\u0006\u0010*\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020&2\u0006\u0010*\u001a\u000209H\u0002J\u0015\u0010;\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b<J\u000e\u0010=\u001a\u0002092\u0006\u00105\u001a\u000206J?\u0010=\u001a\u0002092\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020AH\u0002J?\u0010B\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00101J?\u0010C\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u0002002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00101R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006D"}, d2={"Lcom/github/ajalt/mordant/terminal/Terminal;", "", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "width", "", "height", "hyperlinks", "", "tabWidth", "interactive", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Lcom/github/ajalt/mordant/rendering/Theme;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;ILjava/lang/Boolean;)V", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "(Lcom/github/ajalt/mordant/rendering/Theme;ILcom/github/ajalt/mordant/terminal/TerminalInterface;)V", "colors", "Lcom/github/ajalt/mordant/terminal/TerminalColors;", "getColors", "()Lcom/github/ajalt/mordant/terminal/TerminalColors;", "cursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "getCursor", "()Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "interceptors", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "lock", "getTabWidth", "()I", "getTheme", "()Lcom/github/ajalt/mordant/rendering/Theme;", "addInterceptor", "", "interceptor", "addInterceptor$mordant", "danger", "message", "whitespace", "Lcom/github/ajalt/mordant/rendering/Whitespace;", "align", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "overflowWrap", "Lcom/github/ajalt/mordant/rendering/OverflowWrap;", "(Ljava/lang/Object;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;)V", "forStdErr", "muted", "print", "widget", "Lcom/github/ajalt/mordant/rendering/Widget;", "println", "rawPrint", "", "rawPrintln", "removeInterceptor", "removeInterceptor$mordant", "render", "(Ljava/lang/Object;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;)Ljava/lang/String;", "sendPrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "success", "warning", "mordant"})
public final class Terminal {
    @NotNull
    private final Theme theme;
    private final int tabWidth;
    @NotNull
    private final TerminalInterface terminalInterface;
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private final TerminalColors colors;
    @NotNull
    private final TerminalCursor cursor;
    @NotNull
    private final List<TerminalInterceptor> interceptors;
    @NotNull
    private final Object lock;

    public Terminal(@NotNull Theme theme, int tabWidth, @NotNull TerminalInterface terminalInterface) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)terminalInterface, (String)"terminalInterface");
        this.theme = theme;
        this.tabWidth = tabWidth;
        this.terminalInterface = terminalInterface;
        this.info = this.terminalInterface.getInfo();
        this.colors = new TerminalColors(this.info, this.theme);
        this.cursor = this.info.getInteractive() ? MppImplKt.makePrintingTerminalCursor(this) : (TerminalCursor)DisabledTerminalCursor.INSTANCE;
        this.interceptors = new ArrayList();
        this.lock = new Object();
    }

    public /* synthetic */ Terminal(Theme theme, int n, TerminalInterface terminalInterface, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            theme = Theme.Companion.getDefault();
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        if ((n2 & 4) != 0) {
            terminalInterface = new StdoutTerminalInterface(null, null, null, null, null);
        }
        this(theme, n, terminalInterface);
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    public final int getTabWidth() {
        return this.tabWidth;
    }

    public Terminal(@Nullable AnsiLevel ansiLevel, @NotNull Theme theme, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, int tabWidth, @Nullable Boolean interactive) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this(theme, tabWidth, new StdoutTerminalInterface(ansiLevel, width, height, hyperlinks, interactive));
    }

    public /* synthetic */ Terminal(AnsiLevel ansiLevel, Theme theme, Integer n, Integer n2, Boolean bl, int n3, Boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            ansiLevel = null;
        }
        if ((n4 & 2) != 0) {
            theme = Theme.Companion.getDefault();
        }
        if ((n4 & 4) != 0) {
            n = null;
        }
        if ((n4 & 8) != 0) {
            n2 = null;
        }
        if ((n4 & 0x10) != 0) {
            bl = null;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 8;
        }
        if ((n4 & 0x40) != 0) {
            bl2 = null;
        }
        this(ansiLevel, theme, n, n2, bl, n3, bl2);
    }

    @NotNull
    public final TerminalInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final TerminalColors getColors() {
        return this.colors;
    }

    @NotNull
    public final TerminalCursor getCursor() {
        return this.cursor;
    }

    public final void success(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        this.println(this.theme.getSuccess().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void success$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.success(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void danger(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        this.println(this.theme.getDanger().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void danger$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.danger(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void warning(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        this.println(this.theme.getWarning().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void warning$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.warning(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void info(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        this.println(this.theme.getInfo().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void info$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.info(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void muted(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        this.println(this.theme.getMuted().invoke(String.valueOf(message)), whitespace2, align, overflowWrap2, width);
    }

    public static /* synthetic */ void muted$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.muted(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void print(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        this.rawPrint(this.render(message, whitespace2, align, overflowWrap2, width));
    }

    public static /* synthetic */ void print$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.print(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void println(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        this.rawPrintln(this.render(message, whitespace2, align, overflowWrap2, width));
    }

    public static /* synthetic */ void println$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        terminal.println(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    public final void print(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.rawPrint(this.render(widget));
    }

    public final void println(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.rawPrintln(this.render(widget));
    }

    public final void println() {
        this.sendPrintRequest(new PrintRequest("", true));
    }

    @NotNull
    public final String render(@Nullable Object message, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace2), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap2), (String)"overflowWrap");
        Object object = message;
        return object instanceof Lines ? AnsiRenderKt.renderLinesAnsi((Lines)message, this.info.getAnsiLevel(), this.info.getAnsiHyperLinks()) : (object instanceof Widget ? this.render((Widget)message) : this.render(new Text(String.valueOf(message), whitespace2, align, overflowWrap2, width, null, 32, null)));
    }

    public static /* synthetic */ String render$default(Terminal terminal, Object object, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return terminal.render(object, whitespace2, textAlign2, overflowWrap2, n);
    }

    @NotNull
    public final String render(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        return AnsiRenderKt.renderLinesAnsi(Widget.DefaultImpls.render$default(widget, this, 0, 2, null), this.info.getAnsiLevel(), this.info.getAnsiHyperLinks());
    }

    @NotNull
    public final Terminal forStdErr() {
        return new Terminal(this.theme, this.tabWidth, this.terminalInterface.forStdErr());
    }

    public final void addInterceptor$mordant(@NotNull TerminalInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        ((Collection)this.interceptors).add(interceptor);
    }

    public final void removeInterceptor$mordant(@NotNull TerminalInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        this.interceptors.remove(interceptor);
    }

    private final void rawPrintln(String message) {
        this.sendPrintRequest(new PrintRequest(message, true));
    }

    private final void rawPrint(String message) {
        this.sendPrintRequest(new PrintRequest(message, false));
    }

    private final void sendPrintRequest(PrintRequest request) {
        MppImplKt.sendInterceptedPrintRequest(request, this.terminalInterface, this.interceptors, this.lock);
    }

    public Terminal() {
        this(null, 0, null, 7, null);
    }
}

