/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.FormattingKt;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.widgets.ProgressCell;
import com.github.ajalt.mordant.widgets.ProgressState;
import com.github.ajalt.mordant.widgets.Text;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/ajalt/mordant/widgets/CompletedProgressCell;", "Lcom/github/ajalt/mordant/widgets/ProgressCell;", "suffix", "", "includeTotal", "", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "(Ljava/lang/String;ZLcom/github/ajalt/mordant/rendering/TextStyle;)V", "animationRate", "Lcom/github/ajalt/mordant/widgets/ProgressCell$AnimationRate;", "getAnimationRate", "()Lcom/github/ajalt/mordant/widgets/ProgressCell$AnimationRate;", "columnWidth", "Lcom/github/ajalt/mordant/table/ColumnWidth;", "getColumnWidth", "()Lcom/github/ajalt/mordant/table/ColumnWidth;", "makeWidget", "Lcom/github/ajalt/mordant/rendering/Widget;", "Lcom/github/ajalt/mordant/widgets/ProgressState;", "mordant"})
public final class CompletedProgressCell
implements ProgressCell {
    @NotNull
    private final String suffix;
    private final boolean includeTotal;
    @NotNull
    private final TextStyle style;

    public CompletedProgressCell(@NotNull String suffix, boolean includeTotal, @NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.suffix = suffix;
        this.includeTotal = includeTotal;
        this.style = style;
    }

    @Override
    @NotNull
    public ProgressCell.AnimationRate getAnimationRate() {
        return ProgressCell.AnimationRate.TEXT;
    }

    @Override
    @NotNull
    public ColumnWidth getColumnWidth() {
        return new ColumnWidth.Fixed((this.includeTotal ? 12 : 6) + this.suffix.length());
    }

    @Override
    @NotNull
    public Widget makeWidget(@NotNull ProgressState $this$makeWidget) {
        double d;
        Intrinsics.checkNotNullParameter((Object)$this$makeWidget, (String)"<this>");
        double complete = $this$makeWidget.getCompleted();
        double[] dArray = new double[2];
        dArray[0] = complete;
        Long l = $this$makeWidget.getTotal();
        dArray[1] = l == null ? 0.0 : (d = (double)l.longValue());
        Pair<List<String>, String> pair = FormattingKt.formatMultipleWithSiSuffixes(1, dArray);
        List nums = (List)pair.component1();
        String unit = (String)pair.component2();
        String t = (String)nums.get(0) + (this.includeTotal && $this$makeWidget.getTotal() != null ? '/' + (String)nums.get(1) + unit : (this.includeTotal && $this$makeWidget.getTotal() == null ? "/---.-" : "")) + this.suffix;
        return new Text(this.style.invoke(t), Whitespace.PRE, null, null, null, null, 60, null);
    }
}

