/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.internal.ThemeString;
import com.github.ajalt.mordant.internal.ThemeStyle;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.rendering.WidthRangeKt;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u001cH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/github/ajalt/mordant/widgets/OrderedList;", "Lcom/github/ajalt/mordant/rendering/Widget;", "listEntries", "", "numberStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "numberSeparator", "", "(Ljava/util/List;Lcom/github/ajalt/mordant/rendering/TextStyle;Ljava/lang/String;)V", "Lcom/github/ajalt/mordant/internal/ThemeStyle;", "Lcom/github/ajalt/mordant/internal/ThemeString;", "(Ljava/util/List;Lcom/github/ajalt/mordant/internal/ThemeStyle;Lcom/github/ajalt/mordant/internal/ThemeString;)V", "maxBulletWidth", "", "bulletWidth", "i", "sepWidth", "continuationPadding", "Lcom/github/ajalt/mordant/rendering/Span;", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "sep", "Lcom/github/ajalt/mordant/rendering/Line;", "Lcom/github/ajalt/mordant/rendering/Theme;", "mordant"})
public final class OrderedList
implements Widget {
    @NotNull
    private final List<Widget> listEntries;
    @NotNull
    private final ThemeStyle numberStyle;
    @NotNull
    private final ThemeString numberSeparator;
    private final int maxBulletWidth;

    private OrderedList(List<? extends Widget> listEntries, ThemeStyle numberStyle, ThemeString numberSeparator) {
        this.listEntries = listEntries;
        this.numberStyle = numberStyle;
        this.numberSeparator = numberSeparator;
        if (!(!((Collection)this.listEntries).isEmpty())) {
            boolean bl = false;
            String string = "Cannot render an empty list";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxBulletWidth = this.bulletWidth(this.listEntries.size(), LinesKt.getLineWidth(this.sep(Theme.Companion.getDefault())));
    }

    public OrderedList(@NotNull List<? extends Widget> listEntries, @Nullable TextStyle numberStyle, @Nullable String numberSeparator) {
        Intrinsics.checkNotNullParameter(listEntries, (String)"listEntries");
        this(listEntries, ThemeStyle.Companion.of$default(ThemeStyle.Companion, "list.number", numberStyle, null, 4, null), ThemeString.Companion.of$default(ThemeString.Companion, "list.number.separator", numberSeparator, null, 4, null));
    }

    public /* synthetic */ OrderedList(List list, TextStyle textStyle, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textStyle = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        this((List<? extends Widget>)list, textStyle, string);
    }

    private final Line sep(Theme t) {
        String text = this.numberSeparator.get(t);
        if (!(!StringsKt.contains$default((CharSequence)text, (CharSequence)"\n", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "number separator cannot contain newlines";
            throw new IllegalArgumentException(string.toString());
        }
        Line line = (Line)CollectionsKt.firstOrNull(ParsingKt.parseText(text, this.numberStyle.get(t)).getLines());
        return line == null ? ConstantsKt.getEMPTY_LINE() : line;
    }

    private final List<Span> continuationPadding(int i, int sepWidth) {
        int n = this.bulletWidth(i, sepWidth);
        return CollectionsKt.listOf((Object)Span.Companion.space$default(Span.Companion, n, null, 2, null));
    }

    private final int bulletWidth(int i, int sepWidth) {
        return (int)Math.log10(i + 1) + 1 + 2 + sepWidth;
    }

    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return WidthRangeKt.maxWidthRange((Iterable<? extends Widget>)this.listEntries, t, width, this.maxBulletWidth);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        int contentWidth = width - this.maxBulletWidth;
        List lines = new ArrayList();
        TextStyle style = this.numberStyle.get(t);
        Line sep = this.sep(t.getTheme());
        int sepWidth = LinesKt.getLineWidth(sep);
        Iterator<Widget> iterator = this.listEntries.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Widget entry = iterator.next();
            Object object = new Object[]{ConstantsKt.getSINGLE_SPACE(), Span.Companion.word(String.valueOf(i + 1), style), sep, ConstantsKt.getSINGLE_SPACE()};
            Line bullet = LinesKt.flatLine((Object[])object);
            object = entry.render(t, contentWidth).getLines().iterator();
            int n2 = 0;
            while (object.hasNext()) {
                int j = n2++;
                Line line = (Line)object.next();
                List<Span> start2 = j == 0 ? (List<Span>)bullet : this.continuationPadding(i, sepWidth);
                ((Collection)lines).add(new Line(CollectionsKt.plus((Collection)start2, (Iterable)line)));
            }
        }
        return new Lines(lines);
    }
}

