/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\bH\u0000\u001a,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a8\u0006\u001a"}, d2={"downsample", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "style", "level", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "hyperlinks", "", "makeHyperlinkTag", "", "hyperlink", "hyperlinkId", "makeTag", "old", "new", "renderLinesAnsi", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "invokeStyle", "text", "toAnsi", "", "", "Lcom/github/ajalt/colormath/Color;", "select", "reset", "offset", "mordant"})
public final class AnsiRenderKt {
    @NotNull
    public static final String renderLinesAnsi(@NotNull Lines lines, @NotNull AnsiLevel level, boolean hyperlinks) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        StringBuilder $this$renderLinesAnsi_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterator<Line> iterator = lines.getLines().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Line line = iterator.next();
            if (i > 0) {
                $this$renderLinesAnsi_u24lambda_u2d0.append("\n");
            }
            TextStyle activeStyle = ConstantsKt.getDEFAULT_STYLE();
            for (Span span : line) {
                TextStyle newStyle = AnsiRenderKt.downsample(span.getStyle(), level, hyperlinks);
                $this$renderLinesAnsi_u24lambda_u2d0.append(AnsiRenderKt.makeTag(activeStyle, newStyle));
                activeStyle = newStyle;
                $this$renderLinesAnsi_u24lambda_u2d0.append(span.getText());
            }
            $this$renderLinesAnsi_u24lambda_u2d0.append(AnsiRenderKt.makeTag(activeStyle, ConstantsKt.getDEFAULT_STYLE()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String invokeStyle(@NotNull TextStyle $this$invokeStyle, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeStyle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() == 0) {
            return "";
        }
        Ref.ObjectRef openStyle = new Ref.ObjectRef();
        openStyle.element = $this$invokeStyle;
        Ref.ObjectRef style = new Ref.ObjectRef();
        style.element = $this$invokeStyle;
        String inner2 = ConstantsKt.getANSI_RE().replace((CharSequence)text, (Function1)new Function1<MatchResult, CharSequence>(text, (Ref.ObjectRef<TextStyle>)style, $this$invokeStyle, (Ref.ObjectRef<TextStyle>)openStyle){
            final /* synthetic */ String $text;
            final /* synthetic */ Ref.ObjectRef<TextStyle> $style;
            final /* synthetic */ TextStyle $this_invokeStyle;
            final /* synthetic */ Ref.ObjectRef<TextStyle> $openStyle;
            {
                this.$text = $text;
                this.$style = $style;
                this.$this_invokeStyle = $receiver;
                this.$openStyle = $openStyle;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match) {
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                if (match.getRange().getLast() == StringsKt.getLastIndex((CharSequence)this.$text)) {
                    return "";
                }
                TextStyle textStyle = ParsingKt.updateStyle((TextStyle)this.$style.element, this.$this_invokeStyle, match.getValue());
                if (match.getRange().getFirst() == 0) {
                    this.$openStyle.element = textStyle;
                    this.$style.element = textStyle;
                    return "";
                }
                String tag = AnsiRenderKt.access$makeTag((TextStyle)this.$style.element, textStyle);
                this.$style.element = textStyle;
                return tag;
            }
        });
        return AnsiRenderKt.makeTag(ConstantsKt.getDEFAULT_STYLE(), (TextStyle)openStyle.element) + inner2 + AnsiRenderKt.makeTag((TextStyle)style.element, ConstantsKt.getDEFAULT_STYLE());
    }

    @NotNull
    public static final TextStyle downsample(@NotNull TextStyle style, @NotNull AnsiLevel level, boolean hyperlinks) {
        TextStyle textStyle;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (style == ConstantsKt.getDEFAULT_STYLE()) {
            textStyle = style;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    textStyle = ConstantsKt.getDEFAULT_STYLE();
                    break;
                }
                case 2: {
                    String string;
                    Color color;
                    Color color2;
                    Color color3;
                    Color it;
                    TextStyle textStyle2;
                    Ansi16 ansi16;
                    TextStyle textStyle3 = style;
                    Color color4 = style.getColor();
                    if (color4 == null) {
                        ansi16 = null;
                    } else {
                        Color color5 = color4;
                        textStyle2 = textStyle3;
                        boolean bl = false;
                        ansi16 = it instanceof Ansi16 ? (Ansi16)it : it.toSRGB().clamp().toAnsi16();
                        textStyle3 = textStyle2;
                    }
                    Color color6 = (Color)ansi16;
                    Color color7 = style.getBgColor();
                    if (color7 == null) {
                        color3 = null;
                    } else {
                        it = color7;
                        color2 = color6;
                        textStyle2 = textStyle3;
                        boolean bl = false;
                        color = it instanceof Ansi16 ? (Ansi16)it : it.toSRGB().clamp().toAnsi16();
                        textStyle3 = textStyle2;
                        color6 = color2;
                        color3 = color;
                    }
                    String string2 = string = style.getHyperlink();
                    color = color3;
                    color2 = color6;
                    textStyle2 = textStyle3;
                    boolean bl = false;
                    boolean bl2 = hyperlinks;
                    String string3 = bl2 ? string : null;
                    String it2 = string = style.getHyperlinkId();
                    String string4 = string3;
                    boolean bl3 = false;
                    boolean bl4 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle2, color2, color, string4, bl4 ? string : null);
                    break;
                }
                case 3: {
                    String string;
                    Color color;
                    Color color8;
                    Color color9;
                    Color it;
                    TextStyle textStyle4;
                    Color color10;
                    TextStyle textStyle5 = style;
                    Color color11 = style.getColor();
                    if (color11 == null) {
                        color10 = null;
                    } else {
                        Color bl3 = color11;
                        textStyle4 = textStyle5;
                        boolean bl = false;
                        color10 = it instanceof Ansi16 || it instanceof Ansi256 ? it : (Color)it.toSRGB().clamp().toAnsi256();
                        textStyle5 = textStyle4;
                    }
                    Color color12 = style.getBgColor();
                    if (color12 == null) {
                        color9 = null;
                    } else {
                        it = color12;
                        color8 = color10;
                        textStyle4 = textStyle5;
                        boolean bl = false;
                        color = it instanceof Ansi16 || it instanceof Ansi256 ? it : (Color)it.toSRGB().clamp().toAnsi256();
                        textStyle5 = textStyle4;
                        color10 = color8;
                        color9 = color;
                    }
                    String it3 = string = style.getHyperlink();
                    color = color9;
                    color8 = color10;
                    textStyle4 = textStyle5;
                    boolean bl = false;
                    boolean bl5 = hyperlinks;
                    String string5 = bl5 ? string : null;
                    it3 = string = style.getHyperlinkId();
                    String string6 = string5;
                    boolean bl6 = false;
                    boolean bl7 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle4, color8, color, string6, bl7 ? string : null);
                    break;
                }
                case 4: {
                    if (hyperlinks || style.getHyperlink() == null) {
                        textStyle = style;
                        break;
                    }
                    textStyle = TextStyleKt.copy(style, style.getColor(), style.getBgColor(), null, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return textStyle;
    }

    private static final String makeTag(TextStyle old, TextStyle textStyle) {
        if (Intrinsics.areEqual((Object)old, (Object)textStyle)) {
            return "";
        }
        List codes = new ArrayList();
        if (!Intrinsics.areEqual((Object)old.getColor(), (Object)textStyle.getColor())) {
            CollectionsKt.addAll((Collection)codes, (Iterable)AnsiRenderKt.toAnsi(textStyle.getColor(), 38, 39, 0));
        }
        if (!Intrinsics.areEqual((Object)old.getBgColor(), (Object)textStyle.getBgColor())) {
            CollectionsKt.addAll((Collection)codes, (Iterable)AnsiRenderKt.toAnsi(textStyle.getBgColor(), 48, 49, 10));
        }
        AnsiRenderKt.makeTag$style(codes, old.getBold(), textStyle.getBold(), 1, 22);
        AnsiRenderKt.makeTag$style(codes, old.getItalic(), textStyle.getItalic(), 3, 23);
        AnsiRenderKt.makeTag$style(codes, old.getUnderline(), textStyle.getUnderline(), 4, 24);
        AnsiRenderKt.makeTag$style(codes, old.getDim(), textStyle.getDim(), 2, 22);
        AnsiRenderKt.makeTag$style(codes, old.getInverse(), textStyle.getInverse(), 7, 27);
        AnsiRenderKt.makeTag$style(codes, old.getStrikethrough(), textStyle.getStrikethrough(), 9, 29);
        String csi = codes.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)codes, (CharSequence)";", (CharSequence)"\u001b[", (CharSequence)"m", (int)0, null, null, (int)56, null);
        return !Intrinsics.areEqual((Object)old.getHyperlink(), (Object)textStyle.getHyperlink()) ? Intrinsics.stringPlus((String)csi, (Object)AnsiRenderKt.makeHyperlinkTag(textStyle.getHyperlink(), textStyle.getHyperlinkId())) : csi;
    }

    private static final String makeHyperlinkTag(String hyperlink, String hyperlinkId) {
        String string;
        if (hyperlink == null) {
            return "\u001b]8;;\u001b\\";
        }
        String string2 = hyperlinkId;
        if (string2 == null) {
            string = "";
        } else {
            String it = string2;
            boolean bl = false;
            String string3 = Intrinsics.stringPlus((String)"id=", (Object)it);
            string = string3;
            if (string3 == null) {
                string = "";
            }
        }
        String id = string;
        return "\u001b]8;" + id + ';' + hyperlink + "\u001b\\";
    }

    private static final List<Integer> toAnsi(Color $this$toAnsi, int select, int reset, int offset) {
        List list;
        Color it;
        Color color;
        TextStyle textStyle = $this$toAnsi instanceof TextStyle ? (TextStyle)$this$toAnsi : null;
        if (textStyle == null) {
            color = $this$toAnsi;
        } else {
            color = textStyle.getColor();
            if (color == null) {
                color = it = $this$toAnsi;
            }
        }
        if (it == null) {
            list = CollectionsKt.listOf((Object)reset);
        } else if (it instanceof Ansi16) {
            list = CollectionsKt.listOf((Object)(((Ansi16)it).getCode() + offset));
        } else if (it instanceof Ansi256) {
            Object[] objectArray = new Integer[]{select, 5, ((Ansi256)it).getCode()};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            RGB $this$toAnsi_u24lambda_u2d10 = it.toSRGB().clamp();
            boolean bl = false;
            Object[] objectArray = new Integer[]{select, 2, $this$toAnsi_u24lambda_u2d10.getRedInt(), $this$toAnsi_u24lambda_u2d10.getGreenInt(), $this$toAnsi_u24lambda_u2d10.getBlueInt()};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    private static final void makeTag$style(List<Integer> codes, boolean old, boolean bl, int open, int close) {
        if (old != bl) {
            ((Collection)codes).add(bl ? open : close);
        }
    }

    public static final /* synthetic */ String access$makeTag(TextStyle old, TextStyle textStyle) {
        return AnsiRenderKt.makeTag(old, textStyle);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnsiLevel.values().length];
            nArray[AnsiLevel.NONE.ordinal()] = 1;
            nArray[AnsiLevel.ANSI16.ordinal()] = 2;
            nArray[AnsiLevel.ANSI256.ordinal()] = 3;
            nArray[AnsiLevel.TRUECOLOR.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

