/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.markdown;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.HyperlinkIdsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.markdown.BlockQuote;
import com.github.ajalt.mordant.markdown.MarkdownDocument;
import com.github.ajalt.mordant.markdown.MarkdownRenderer;
import com.github.ajalt.mordant.markdown.MarkdownRendererKt;
import com.github.ajalt.mordant.rendering.BorderType;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.TxtStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.RowBuilder;
import com.github.ajalt.mordant.table.SectionBuilder;
import com.github.ajalt.mordant.table.TableBuilder;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.widgets.EmptyWidget;
import com.github.ajalt.mordant.widgets.HorizontalRule;
import com.github.ajalt.mordant.widgets.OrderedList;
import com.github.ajalt.mordant.widgets.PaddingKt;
import com.github.ajalt.mordant.widgets.Panel;
import com.github.ajalt.mordant.widgets.Text;
import com.github.ajalt.mordant.widgets.UnorderedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010'\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010(\u001a\u00020\u001f2\b\b\u0002\u0010)\u001a\u00020\u001fH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u00101\u001a\u00020+J\u0010\u00102\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u00104\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u00105\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u00106\u001a\u00020\u0003*\u00020\u00172\b\b\u0002\u0010(\u001a\u00020\u001fH\u0002J\u0014\u00107\u001a\u000208*\u0002092\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/github/ajalt/mordant/markdown/MarkdownRenderer;", "", "input", "", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "showHtml", "", "hyperlinks", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/Theme;ZZ)V", "CHECK_BOX_REGEX", "Lkotlin/text/Regex;", "getCHECK_BOX_REGEX$annotations", "()V", "EOL_LINES", "Lcom/github/ajalt/mordant/rendering/Lines;", "EOL_TEXT", "Lcom/github/ajalt/mordant/widgets/Text;", "TABLE_DELIMITER_REGEX", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "atxContent", "node", "Lorg/intellij/markdown/ast/ASTNode;", "atxHr", "Lcom/github/ajalt/mordant/rendering/Widget;", "bar", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "dropWs", "Lkotlin/Pair;", "", "nodes", "", "findLinkDest", "findLinkLabel", "findLinkText", "headerHr", "content", "innerInlines", "drop", "dropLast", "parseFile", "Lcom/github/ajalt/mordant/markdown/MarkdownDocument;", "parseInlines", "parseStructure", "parseTableAlignment", "Lkotlin/sequences/Sequence;", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "render", "renderImageLink", "renderInlineLink", "renderReferenceLink", "setext", "nodeText", "parseTableRow", "", "Lcom/github/ajalt/mordant/table/SectionBuilder;", "mordant"})
public final class MarkdownRenderer {
    @NotNull
    private final Theme theme;
    private final boolean showHtml;
    private final boolean hyperlinks;
    @NotNull
    private final Lines EOL_LINES;
    @NotNull
    private final Text EOL_TEXT;
    @NotNull
    private final Regex TABLE_DELIMITER_REGEX;
    @NotNull
    private final Regex CHECK_BOX_REGEX;
    @NotNull
    private final String input;
    @Nullable
    private LinkMap linkMap;

    public MarkdownRenderer(@NotNull String input, @NotNull Theme theme, boolean showHtml, boolean hyperlinks) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.theme = theme;
        this.showHtml = showHtml;
        this.hyperlinks = hyperlinks;
        Object[] objectArray = new Line[]{ConstantsKt.getEMPTY_LINE(), ConstantsKt.getEMPTY_LINE()};
        this.EOL_LINES = new Lines(CollectionsKt.listOf((Object[])objectArray));
        this.EOL_TEXT = new Text(this.EOL_LINES, Whitespace.PRE, null, null, null, null, 60, null);
        this.TABLE_DELIMITER_REGEX = new Regex(":?-+:?");
        this.CHECK_BOX_REGEX = new Regex("\\[[^\\]]\\]");
        this.input = StringsKt.replace$default((String)input, (String)"\r", (String)"", (boolean)false, (int)4, null);
    }

    private static /* synthetic */ void getCHECK_BOX_REGEX$annotations() {
    }

    @NotNull
    public final MarkdownDocument render() {
        MarkdownFlavourDescriptor flavour = (MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, false, 3, null);
        ASTNode parsedTree = new MarkdownParser(flavour, false, 2, null).buildMarkdownTreeFromString(this.input);
        return this.parseFile(parsedTree);
    }

    /*
     * WARNING - void declaration
     */
    private final MarkdownDocument parseFile(ASTNode node) {
        void $this$mapTo$iv$iv;
        if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.MARKDOWN_FILE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.hyperlinks) {
            this.linkMap = LinkMap.Builder.buildLinkMap(node, (CharSequence)this.input);
        }
        Iterable $this$map$iv = node.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.parseStructure((ASTNode)it));
        }
        List list = (List)destination$iv$iv;
        return new MarkdownDocument(list);
    }

    /*
     * WARNING - void declaration
     */
    private final Widget parseStructure(ASTNode node) {
        Widget widget;
        IElementType iElementType = node.getType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
            void $this$mapTo$iv$iv;
            ASTNode it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getChildren();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                it = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = CollectionsKt.drop((Iterable)it.getChildren(), (int)1);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void c;
                    ASTNode aSTNode = (ASTNode)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(this.parseStructure((ASTNode)c));
                }
                List list = (List)destination$iv$iv2;
                collection.add(new MarkdownDocument(list));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            TextStyle textStyle = null;
            String string = null;
            List list = (List)destination$iv$iv;
            widget = new UnorderedList(list, string, textStyle, n, defaultConstructorMarker);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
            ASTNode it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getChildren();
            boolean $i$f$filter = false;
            Iterable $this$mapTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv3 = CollectionsKt.drop((Iterable)it.getChildren(), (int)1);
                boolean $i$f$map3 = false;
                Iterable $this$mapTo$iv$iv2 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    ASTNode c = (ASTNode)item$iv$iv3;
                    Collection collection3 = destination$iv$iv3;
                    boolean bl3 = false;
                    collection3.add(this.parseStructure(c));
                }
                List list = (List)destination$iv$iv3;
                collection.add(new MarkdownDocument(list));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            String string = null;
            TextStyle textStyle = null;
            List list = (List)destination$iv$iv;
            widget = new OrderedList(list, textStyle, string, n, defaultConstructorMarker);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
            ASTNode it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CollectionsKt.drop((Iterable)node.getChildren(), (int)1);
            boolean $i$f$filter = false;
            Iterable $this$mapTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.parseStructure(it));
            }
            List list = (List)destination$iv$iv;
            Widget widget2 = new MarkdownDocument(list);
            widget = new BlockQuote(widget2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
            int n;
            int start2;
            block54: {
                int n2;
                block53: {
                    List $this$indexOfFirst$iv = node.getChildren();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        ASTNode it = (ASTNode)item$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                            n2 = index$iv;
                            break block53;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                start2 = n2;
                List $this$indexOfLast$iv = node.getChildren();
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    ASTNode it = (ASTNode)iterator$iv.previous();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) continue;
                    n = iterator$iv.nextIndex();
                    break block54;
                }
                n = -1;
            }
            int end = n;
            int dropLast = end < 0 ? 0 : CollectionsKt.getLastIndex((List)node.getChildren()) - end;
            Lines lines = this.innerInlines(node, start2, dropLast);
            Text content = new Text(lines.withStyle$mordant(Theme.style$default(this.theme, "markdown.code.block", null, 2, null)), Whitespace.PRE_WRAP, null, null, null, null, 60, null);
            widget = Theme.flag$default(this.theme, "markdown.code.block.border", false, 2, null) ? (Widget)new Panel(content, null, null, false, null, null, null, null, null, null, 1022, null) : (Widget)content;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK)) {
            Text content = new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null).withStyle$mordant(Theme.style$default(this.theme, "markdown.code.block", null, 2, null)), Whitespace.PRE_WRAP, null, null, null, null, 60, null);
            widget = Theme.flag$default(this.theme, "markdown.code.block.border", false, 2, null) ? (Widget)new Panel(content, null, null, false, null, null, null, null, null, null, 1022, null) : (Widget)content;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.HTML_BLOCK)) {
            widget = this.showHtml ? new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null), Whitespace.PRE_WRAP, null, null, null, null, 60, null) : new Text(ConstantsKt.getEMPTY_LINES(), null, null, null, null, null, 62, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH)) {
            widget = new Text(MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null), Whitespace.NORMAL, null, null, null, null, 60, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_DEFINITION)) {
            widget = this.hyperlinks ? (Widget)EmptyWidget.INSTANCE : (Widget)new Text(ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), Theme.style$default(this.theme, "markdown.link.destination", null, 2, null)), Whitespace.NORMAL, null, null, null, null, 60, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SETEXT_1)) {
            widget = this.setext(Theme.string$default(this.theme, "markdown.h1.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h1", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SETEXT_2)) {
            widget = this.setext(Theme.string$default(this.theme, "markdown.h2.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h2", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1)) {
            widget = this.atxHr(Theme.string$default(this.theme, "markdown.h1.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h1", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) {
            widget = this.atxHr(Theme.string$default(this.theme, "markdown.h2.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h2", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) {
            widget = this.atxHr(Theme.string$default(this.theme, "markdown.h3.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h3", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) {
            widget = this.atxHr(Theme.string$default(this.theme, "markdown.h4.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h4", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) {
            widget = this.atxHr(Theme.string$default(this.theme, "markdown.h5.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h5", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) {
            widget = this.atxHr(Theme.string$default(this.theme, "markdown.h6.rule", null, 2, null), Theme.style$default(this.theme, "markdown.h6", null, 2, null), node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CHECK_BOX)) {
            MatchResult matchResult = Regex.find$default((Regex)this.CHECK_BOX_REGEX, (CharSequence)MarkdownRenderer.nodeText$default(this, node, 0, 1, null), (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            String content = StringsKt.removeSurrounding((String)matchResult.getValue(), (CharSequence)"[", (CharSequence)"]");
            String checkbox = StringsKt.isBlank((CharSequence)content) ? Theme.string$default(this.theme, "markdown.task.unchecked", null, 2, null) : Theme.string$default(this.theme, "markdown.task.checked", null, 2, null);
            widget = new Text(ParsingKt.parseText(Intrinsics.stringPlus((String)checkbox, (Object)" "), ConstantsKt.getDEFAULT_STYLE()), Whitespace.PRE, null, null, null, null, 60, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.TABLE)) {
            widget = TableDslKt.table((Function1<? super TableBuilder, Unit>)((Function1)new Function1<TableBuilder, Unit>(this, node){
                final /* synthetic */ MarkdownRenderer this$0;
                final /* synthetic */ ASTNode $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull TableBuilder $this$table) {
                    Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
                    $this$table.setBorderType(Theme.flag$default(MarkdownRenderer.access$getTheme$p(this.this$0), "markdown.table.ascii", false, 2, null) ? BorderType.Companion.getASCII_DOUBLE_SECTION_SEPARATOR() : BorderType.Companion.getSQUARE_DOUBLE_SECTION_SEPARATOR());
                    Sequence $this$forEachIndexed$iv = MarkdownRenderer.access$parseTableAlignment(this.this$0, this.$node);
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (E item$iv : $this$forEachIndexed$iv) {
                        void align;
                        int n = index$iv;
                        index$iv = n + 1;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        TextAlign textAlign2 = (TextAlign)((Object)item$iv);
                        int i = n;
                        boolean bl = false;
                        $this$table.column(i, (Function1<? super ColumnBuilder, Unit>)((Function1)new Function1<ColumnBuilder, Unit>((TextAlign)align){
                            final /* synthetic */ TextAlign $align;
                            {
                                this.$align = $align;
                                super(1);
                            }

                            public final void invoke(@NotNull ColumnBuilder $this$column) {
                                Intrinsics.checkNotNullParameter((Object)$this$column, (String)"$this$column");
                                $this$column.setAlign(this.$align);
                            }
                        }));
                    }
                    $this$table.header((Function1<? super SectionBuilder, Unit>)((Function1)new Function1<SectionBuilder, Unit>(this.this$0, this.$node){
                        final /* synthetic */ MarkdownRenderer this$0;
                        final /* synthetic */ ASTNode $node;
                        {
                            this.this$0 = $receiver;
                            this.$node = $node;
                            super(1);
                        }

                        public final void invoke(@NotNull SectionBuilder $this$header) {
                            Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$this$header");
                            $this$header.setStyle(Theme.style$default(MarkdownRenderer.access$getTheme$p(this.this$0), "markdown.table.header", null, 2, null));
                            MarkdownRenderer.access$parseTableRow(this.this$0, $this$header, MarkdownRendererKt.access$firstChildOfType(this.$node, GFMElementTypes.HEADER));
                        }
                    }));
                    $this$table.body((Function1<? super SectionBuilder, Unit>)((Function1)new Function1<SectionBuilder, Unit>(this.this$0, this.$node){
                        final /* synthetic */ MarkdownRenderer this$0;
                        final /* synthetic */ ASTNode $node;
                        {
                            this.this$0 = $receiver;
                            this.$node = $node;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull SectionBuilder $this$body) {
                            void $this$forEach$iv;
                            void $this$filterTo$iv$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$this$body");
                            $this$body.setStyle(Theme.style$default(MarkdownRenderer.access$getTheme$p(this.this$0), "markdown.table.body", null, 2, null));
                            Iterable $this$filter$iv = this.$node.getChildren();
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                ASTNode it = (ASTNode)element$iv$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)GFMElementTypes.ROW)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            MarkdownRenderer markdownRenderer = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                ASTNode it = (ASTNode)element$iv;
                                boolean bl = false;
                                MarkdownRenderer.access$parseTableRow(markdownRenderer, $this$body, it);
                            }
                        }
                    }));
                }
            }));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HORIZONTAL_RULE)) {
            widget = new HorizontalRule("", null, null, null, null, false, 62, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
            widget = this.EOL_TEXT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            widget = new Text(ConstantsKt.getEMPTY_LINES(), null, null, null, null, null, 62, null);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected token when parsing structure: ", (Object)node).toString());
        }
        return widget;
    }

    private final Lines parseInlines(ASTNode node) {
        Lines lines;
        IElementType iElementType = node.getType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN)) {
            String string = this.input.substring(((ASTNode)node.getChildren().get(1)).getStartOffset(), ((ASTNode)CollectionsKt.last((List)node.getChildren())).getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            lines = ParsingKt.parseText(((Object)StringsKt.trim((CharSequence)string)).toString(), Theme.style$default(this.theme, "markdown.code.span", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 1, 0, 4, null).withStyle$mordant(Theme.style$default(this.theme, "markdown.emph", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 2, 0, 4, null).withStyle$mordant(Theme.style$default(this.theme, "markdown.strong", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.STRIKETHROUGH)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 2, 0, 4, null).withStyle$mordant(Theme.style$default(this.theme, "markdown.stikethrough", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_TEXT)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, (ASTNode)node.getChildren().get(1), 0, 1, null), Theme.style$default(this.theme, "markdown.link.text", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_LABEL)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), Theme.style$default(this.theme, "markdown.link.destination", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_DESTINATION)) {
            ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull((List)node.getChildren());
            lines = MarkdownRenderer.innerInlines$default(this, node, Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getType()), (Object)MarkdownTokenTypes.LT) ? 1 : 0, 0, 4, null).replaceStyle$mordant(Theme.style$default(this.theme, "markdown.link.destination", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
            lines = this.renderInlineLink(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK)) {
            lines = this.renderReferenceLink(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.IMAGE)) {
            lines = this.renderImageLink(node);
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMAIL_AUTOLINK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.GFM_AUTOLINK)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.AUTOLINK)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), Theme.style$default(this.theme, "markdown.link.text", null, 2, null));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.AUTOLINK)) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 1, 0, 4, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HTML_TAG)) {
            lines = this.showHtml ? ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), ConstantsKt.getDEFAULT_STYLE()) : ConstantsKt.getEMPTY_LINES();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
            lines = ConstantsKt.getEMPTY_LINES();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE)) {
            lines = ParsingKt.parseText(StringsKt.drop((String)MarkdownRenderer.nodeText$default(this, node, 0, 1, null), (int)4), ConstantsKt.getDEFAULT_STYLE());
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HARD_LINE_BREAK)) {
            lines = ParsingKt.parseText("\u0085", ConstantsKt.getDEFAULT_STYLE());
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) {
            lines = ParsingKt.parseText("`", ConstantsKt.getDEFAULT_STYLE());
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BAD_CHARACTER)) {
            lines = ParsingKt.parseText("\ufffd", ConstantsKt.getDEFAULT_STYLE());
        } else if (((((((((((((((((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.BACKTICK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.COLON)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOUBLE_QUOTE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EXCLAMATION_MARK)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.GT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.HTML_BLOCK_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LBRACKET)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LPAREN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RBRACKET)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RPAREN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SINGLE_QUOTE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.URL)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.TILDE)) {
            lines = ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), ConstantsKt.getDEFAULT_STYLE());
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
            lines = new Lines(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)ConstantsKt.getEMPTY_LINE()), (Iterable)ParsingKt.parseText(MarkdownRenderer.nodeText$default(this, node, 0, 1, null), ConstantsKt.getDEFAULT_STYLE()).getLines()));
        } else {
            throw new IllegalStateException(("Unexpected token when parsing inlines: " + node + "; [" + node.getType() + ":'" + StringsKt.take((String)MarkdownRenderer.nodeText$default(this, node, 0, 1, null), (int)10) + "'}]").toString());
        }
        return lines;
    }

    private final String nodeText(ASTNode $this$nodeText, int drop) {
        String string = this.input.substring($this$nodeText.getStartOffset() + drop, $this$nodeText.getEndOffset() - drop);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    static /* synthetic */ String nodeText$default(MarkdownRenderer markdownRenderer, ASTNode aSTNode, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return markdownRenderer.nodeText(aSTNode, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Lines innerInlines(ASTNode node, int drop, int dropLast) {
        void $this$fold$iv$iv;
        void $this$foldLines$iv;
        List list = node.getChildren().subList(drop, node.getChildren().size() - dropLast);
        boolean $i$f$foldLines = false;
        Iterable iterable = (Iterable)$this$foldLines$iv;
        Lines initial$iv$iv = ConstantsKt.getEMPTY_LINES();
        boolean $i$f$fold = false;
        Lines accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            Lines lines;
            void r$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Lines l$iv = accumulator$iv$iv;
            boolean bl = false;
            ASTNode it = (ASTNode)r$iv;
            boolean bl2 = false;
            Lines other$iv = this.parseInlines(it);
            if (l$iv.getLines().isEmpty()) {
                lines = other$iv;
            } else if (other$iv.getLines().isEmpty()) {
                lines = l$iv;
            } else {
                Object[] objectArray = new List[]{CollectionsKt.dropLast(l$iv.getLines(), (int)1), CollectionsKt.listOf((Object)new Line(CollectionsKt.plus((Collection)((Collection)CollectionsKt.last(l$iv.getLines())), (Iterable)((Iterable)CollectionsKt.first(other$iv.getLines()))))), CollectionsKt.drop((Iterable)other$iv.getLines(), (int)1)};
                lines = new Lines(CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray)));
            }
            accumulator$iv$iv = lines;
        }
        return accumulator$iv$iv;
    }

    static /* synthetic */ Lines innerInlines$default(MarkdownRenderer markdownRenderer, ASTNode aSTNode, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return markdownRenderer.innerInlines(aSTNode, n, n2);
    }

    private final Widget atxHr(String bar, TextStyle style, ASTNode node) {
        return node.getChildren().size() <= 1 ? (Widget)this.EOL_TEXT : this.headerHr(new Text(this.atxContent(node).withStyle$mordant(style), Whitespace.NORMAL, null, null, null, null, 60, null), bar, style);
    }

    private final Lines atxContent(ASTNode node) {
        Pair<Integer, Integer> pair = this.dropWs(((ASTNode)node.getChildren().get(1)).getChildren());
        int drop = ((Number)pair.component1()).intValue();
        int dropLast = ((Number)pair.component2()).intValue();
        return this.innerInlines((ASTNode)node.getChildren().get(1), drop, dropLast);
    }

    private final Widget setext(String bar, TextStyle style, ASTNode node) {
        Pair<Integer, Integer> pair = this.dropWs(((ASTNode)node.getChildren().get(0)).getChildren());
        int drop = ((Number)pair.component1()).intValue();
        int dropLast = ((Number)pair.component2()).intValue();
        Lines content = this.innerInlines((ASTNode)node.getChildren().get(0), drop, dropLast);
        return this.headerHr(new Text(content.withStyle$mordant(style), Whitespace.NORMAL, null, null, null, null, 60, null), bar, style);
    }

    private final Widget headerHr(Widget content, String bar, TextStyle style) {
        return PaddingKt.withVerticalPadding$default(new HorizontalRule(content, bar, TextStyleKt.TextStyle$default(style.getColor(), style.getBgColor(), false, false, false, false, false, false, null, 508, null), null, null, false, 56, null), Theme.dimension$default(this.theme, "markdown.header.padding", 0, 2, null), false, 2, null);
    }

    private final Pair<Integer, Integer> dropWs(List<? extends ASTNode> nodes) {
        ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull(nodes);
        int drop = Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getType()), (Object)MarkdownTokenTypes.WHITE_SPACE) ? 1 : 0;
        int dropLast = nodes.size() > 1 && Intrinsics.areEqual((Object)((ASTNode)CollectionsKt.last(nodes)).getType(), (Object)MarkdownTokenTypes.WHITE_SPACE) ? 1 : 0;
        return TuplesKt.to((Object)drop, (Object)dropLast);
    }

    private final void parseTableRow(SectionBuilder $this$parseTableRow, ASTNode node) {
        $this$parseTableRow.row((Function1<? super RowBuilder, Unit>)((Function1)new Function1<RowBuilder, Unit>(node, this){
            final /* synthetic */ ASTNode $node;
            final /* synthetic */ MarkdownRenderer this$0;
            {
                this.$node = $node;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RowBuilder $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                for (ASTNode child : this.$node.getChildren()) {
                    if (!Intrinsics.areEqual((Object)child.getType(), (Object)GFMTokenTypes.CELL)) continue;
                    Pair pair = MarkdownRenderer.access$dropWs(this.this$0, child.getChildren());
                    int drop = ((Number)pair.component1()).intValue();
                    int dropLast = ((Number)pair.component2()).intValue();
                    RowBuilder.DefaultImpls.cell$default($this$row, new Text(MarkdownRenderer.access$innerInlines(this.this$0, child, drop, dropLast), Whitespace.NORMAL, null, null, null, null, 60, null), null, 2, null);
                }
            }
        }));
    }

    private final Sequence<TextAlign> parseTableAlignment(ASTNode node) {
        ASTNode headerSeparator = MarkdownRendererKt.access$firstChildOfType(node, GFMTokenTypes.TABLE_SEPARATOR);
        return SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.TABLE_DELIMITER_REGEX, (CharSequence)MarkdownRenderer.nodeText$default(this, headerSeparator, 0, 1, null), (int)0, (int)2, null), (Function1)parseTableAlignment.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Lines renderInlineLink(ASTNode node) {
        void $this$fold$iv$iv;
        String dest;
        Lines lines = this.findLinkText(node);
        Intrinsics.checkNotNull((Object)lines);
        Lines text = lines;
        String string = this.findLinkDest(node);
        if (string == null) {
            string = dest = "";
        }
        if (this.hyperlinks && !StringsKt.isBlank((CharSequence)dest)) {
            return text.replaceStyle$mordant(TextStyleKt.copy$default(Theme.style$default(this.theme, "markdown.link.text", null, 2, null), null, null, dest, HyperlinkIdsKt.generateHyperlinkId(), 3, null));
        }
        Lines parsedText = text.replaceStyle$mordant(Theme.style$default(this.theme, "markdown.link.text", null, 2, null));
        Lines parsedDest = ParsingKt.parseText('(' + dest + ')', Theme.style$default(this.theme, "markdown.link.destination", null, 2, null));
        Object[] objectArray = new Lines[]{parsedText, parsedDest};
        List $this$foldLines$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$foldLines = false;
        Iterable iterable = $this$foldLines$iv;
        Lines initial$iv$iv = ConstantsKt.getEMPTY_LINES();
        boolean $i$f$fold = false;
        Lines accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            Lines lines2;
            void r$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Lines l$iv = accumulator$iv$iv;
            boolean bl = false;
            Lines it = (Lines)r$iv;
            boolean bl2 = false;
            Lines other$iv = it;
            if (l$iv.getLines().isEmpty()) {
                lines2 = other$iv;
            } else if (other$iv.getLines().isEmpty()) {
                lines2 = l$iv;
            } else {
                Object[] objectArray2 = new List[]{CollectionsKt.dropLast(l$iv.getLines(), (int)1), CollectionsKt.listOf((Object)new Line(CollectionsKt.plus((Collection)((Collection)CollectionsKt.last(l$iv.getLines())), (Iterable)((Iterable)CollectionsKt.first(other$iv.getLines()))))), CollectionsKt.drop((Iterable)other$iv.getLines(), (int)1)};
                lines2 = new Lines(CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray2)));
            }
            accumulator$iv$iv = lines2;
        }
        return accumulator$iv$iv;
    }

    private final Lines renderReferenceLink(ASTNode node) {
        Lines lines;
        String hyperlink;
        String string;
        if (!this.hyperlinks) {
            return MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null);
        }
        String string2 = this.findLinkLabel(node);
        Intrinsics.checkNotNull((Object)string2);
        String label = string2;
        LinkMap linkMap = this.linkMap;
        if (linkMap == null) {
            string = null;
        } else {
            LinkMap.LinkInfo linkInfo = linkMap.getLinkInfo((CharSequence)('[' + label + ']'));
            if (linkInfo == null) {
                string = null;
            } else {
                CharSequence charSequence = linkInfo.getDestination();
                string = hyperlink = charSequence == null ? null : ((Object)charSequence).toString();
            }
        }
        if (hyperlink == null) {
            lines = MarkdownRenderer.innerInlines$default(this, node, 0, 0, 6, null);
        } else {
            TxtStyle style = TextStyleKt.copy$default(Theme.style$default(this.theme, "markdown.link.text", null, 2, null), null, null, hyperlink, HyperlinkIdsKt.generateHyperlinkId(), 3, null);
            Lines lines2 = this.findLinkText(node);
            lines = lines2 == null ? null : lines2.replaceStyle$mordant(style);
            if (lines == null) {
                lines = ParsingKt.parseText(label, style);
            }
        }
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    private final Lines renderImageLink(ASTNode node) {
        void $this$fold$iv$iv;
        void $this$foldLines$iv;
        Object object;
        Object object2;
        Object object3;
        ASTNode link;
        Lines lines;
        Object object4 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.INLINE_LINK);
        if (object4 == null && (object4 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.FULL_REFERENCE_LINK)) == null) {
            lines = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.SHORT_REFERENCE_LINK);
            if (lines == null) {
                return ConstantsKt.getEMPTY_LINES();
            }
            object4 = lines;
        }
        if ((lines = this.findLinkText(link = object4)) == null) {
            object3 = null;
        } else {
            object2 = lines;
            Lines it = object2;
            boolean bl = false;
            object3 = object = !it.isEmpty() ? object2 : null;
        }
        if (object == null) {
            return ConstantsKt.getEMPTY_LINES();
        }
        Object[] text = object;
        object = new Lines[]{ParsingKt.parseText("\ud83d\uddbc\ufe0f ", ConstantsKt.getDEFAULT_STYLE()), text.replaceStyle$mordant(Theme.style$default(this.theme, "markdown.img.alt-text", null, 2, null))};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$foldLines = false;
        object2 = (Iterable)$this$foldLines$iv;
        Lines initial$iv$iv = ConstantsKt.getEMPTY_LINES();
        boolean $i$f$fold = false;
        Lines accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            Lines lines2;
            void r$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Lines l$iv = accumulator$iv$iv;
            boolean bl = false;
            Lines it = (Lines)r$iv;
            boolean bl2 = false;
            Lines other$iv = it;
            if (l$iv.getLines().isEmpty()) {
                lines2 = other$iv;
            } else if (other$iv.getLines().isEmpty()) {
                lines2 = l$iv;
            } else {
                Object[] objectArray = new List[]{CollectionsKt.dropLast(l$iv.getLines(), (int)1), CollectionsKt.listOf((Object)new Line(CollectionsKt.plus((Collection)((Collection)CollectionsKt.last(l$iv.getLines())), (Iterable)((Iterable)CollectionsKt.first(other$iv.getLines()))))), CollectionsKt.drop((Iterable)other$iv.getLines(), (int)1)};
                lines2 = new Lines(CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray)));
            }
            accumulator$iv$iv = lines2;
        }
        return accumulator$iv$iv;
    }

    private final String findLinkLabel(ASTNode node) {
        String string;
        ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_LABEL);
        if (aSTNode == null) {
            string = null;
        } else {
            List list = aSTNode.getChildren();
            if (list == null) {
                string = null;
            } else {
                ASTNode aSTNode2 = (ASTNode)list.get(1);
                string = aSTNode2 == null ? null : MarkdownRenderer.nodeText$default(this, aSTNode2, 0, 1, null);
            }
        }
        return string;
    }

    private final String findLinkDest(ASTNode node) {
        String string;
        ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_DESTINATION);
        if (aSTNode == null) {
            string = null;
        } else {
            List list = aSTNode.getChildren();
            if (list == null) {
                string = null;
            } else {
                Object v1;
                block5: {
                    for (Object t : (Iterable)list) {
                        ASTNode it = (ASTNode)t;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.GFM_AUTOLINK))) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                ASTNode aSTNode2 = v1;
                string = aSTNode2 == null ? null : MarkdownRenderer.nodeText$default(this, aSTNode2, 0, 1, null);
            }
        }
        return string;
    }

    private final Lines findLinkText(ASTNode node) {
        Lines lines;
        ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_TEXT);
        if (aSTNode == null) {
            lines = null;
        } else {
            ASTNode it = aSTNode;
            boolean bl = false;
            lines = MarkdownRenderer.innerInlines$default(this, it, 1, 0, 4, null);
        }
        return lines;
    }

    public static final /* synthetic */ Theme access$getTheme$p(MarkdownRenderer $this) {
        return $this.theme;
    }

    public static final /* synthetic */ Sequence access$parseTableAlignment(MarkdownRenderer $this, ASTNode node) {
        return $this.parseTableAlignment(node);
    }

    public static final /* synthetic */ void access$parseTableRow(MarkdownRenderer $this, SectionBuilder $receiver, ASTNode node) {
        $this.parseTableRow($receiver, node);
    }

    public static final /* synthetic */ Pair access$dropWs(MarkdownRenderer $this, List nodes) {
        return $this.dropWs(nodes);
    }

    public static final /* synthetic */ Lines access$innerInlines(MarkdownRenderer $this, ASTNode node, int drop, int dropLast) {
        return $this.innerInlines(node, drop, dropLast);
    }
}

