/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.rendering.BorderType;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.VerticalAlign;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.CellBuilderInstance;
import com.github.ajalt.mordant.table.CellContent;
import com.github.ajalt.mordant.table.CellStyleBuilder;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.RowBuilderInstance;
import com.github.ajalt.mordant.table.SectionBuilderInstance;
import com.github.ajalt.mordant.table.TableBuilderInstance;
import com.github.ajalt.mordant.table.TableImpl;
import com.github.ajalt.mordant.table.TableLayout;
import com.github.ajalt.mordant.table.TableLayoutKt;
import com.github.ajalt.mordant.widgets.Padding;
import com.github.ajalt.mordant.widgets.PaddingKt;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u00062\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/table/TableLayout;", "", "table", "Lcom/github/ajalt/mordant/table/TableBuilderInstance;", "(Lcom/github/ajalt/mordant/table/TableBuilderInstance;)V", "buildSection", "", "Lcom/github/ajalt/mordant/table/Cell;", "Lcom/github/ajalt/mordant/table/MutableRow;", "section", "Lcom/github/ajalt/mordant/table/SectionBuilderInstance;", "builderWidth", "", "buildTable", "Lcom/github/ajalt/mordant/table/TableImpl;", "insertCell", "", "cell", "Lcom/github/ajalt/mordant/table/CellBuilderInstance;", "rows", "startingX", "startingY", "mordant"})
public final class TableLayout {
    @NotNull
    private final TableBuilderInstance table;

    public TableLayout(@NotNull TableBuilderInstance table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TableImpl buildTable() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        int it2;
        Iterator<Object> r;
        Iterator<Object> iterator;
        Object[] objectArray = new SectionBuilderInstance[]{this.table.getHeaderSection(), this.table.getBodySection(), this.table.getFooterSection()};
        Iterator iterator2 = ((Iterable)CollectionsKt.listOf((Object[])objectArray)).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        SectionBuilderInstance it2 = (SectionBuilderInstance)iterator2.next();
        boolean bl = false;
        Iterator iterator3 = ((Iterable)it2.getRows()).iterator();
        if (!iterator3.hasNext()) {
            iterator = null;
        } else {
            r = (RowBuilderInstance)iterator3.next();
            boolean bl2 = false;
            r = ((RowBuilderInstance)((Object)r)).getCells().size();
            while (iterator3.hasNext()) {
                Object r2 = (RowBuilderInstance)iterator3.next();
                bl3 = false;
                if (r.compareTo((Object)(r2 = (Comparable)Integer.valueOf(((RowBuilderInstance)r2).getCells().size()))) >= 0) continue;
                r = r2;
            }
            iterator = r;
        }
        Integer n = (Integer)((Object)iterator);
        int n2 = it2 = n == null ? 0 : n;
        while (iterator2.hasNext()) {
            Object object;
            SectionBuilderInstance it222 = (SectionBuilderInstance)iterator2.next();
            $i$a$-maxOf-TableLayout$buildTable$builderWidth$1 = false;
            r = ((Iterable)it222.getRows()).iterator();
            if (!r.hasNext()) {
                object = null;
            } else {
                Object r3 = (RowBuilderInstance)r.next();
                boolean bl3 = false;
                r3 = ((RowBuilderInstance)r3).getCells().size();
                while (r.hasNext()) {
                    Object r4 = (RowBuilderInstance)r.next();
                    $i$a$-maxOfOrNull-TableLayout$buildTable$builderWidth$1$1 = false;
                    if (r3.compareTo(r4 = (Comparable)Integer.valueOf(((RowBuilderInstance)r4).getCells().size())) >= 0) continue;
                    r3 = r4;
                }
                object = r3;
            }
            Integer n3 = (Integer)object;
            int it222 = n3 == null ? 0 : n3;
            if (it2 >= it222) continue;
            it2 = it222;
        }
        int builderWidth = it2;
        List<List<Cell>> header = this.buildSection(this.table.getHeaderSection(), builderWidth);
        List<List<Cell>> body = this.buildSection(this.table.getBodySection(), builderWidth);
        List<List<Cell>> footer = this.buildSection(this.table.getFooterSection(), builderWidth);
        Object it222 = new List[]{header, body, footer};
        List list = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])it222));
        it222 = this.table.getColumns();
        int n4 = footer.size();
        int n5 = header.size();
        TextStyle textStyle = this.table.getBorderStyle();
        BorderType borderType = this.table.getBorderType();
        List list2 = list;
        boolean $i$f$mapValues = false;
        iterator3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it3;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map2;
            boolean bl5 = false;
            ColumnWidth columnWidth = ((ColumnBuilder)it3.getValue()).getWidth();
            map.put(k, columnWidth);
        }
        map = destination$iv$iv;
        boolean bl6 = this.table.getOuterBorder();
        Map map3 = map;
        int n6 = n4;
        int n7 = n5;
        TextStyle textStyle2 = textStyle;
        BorderType borderType2 = borderType;
        List list3 = list2;
        return new TableImpl(list3, borderType2, textStyle2, n7, n6, map3, bl6);
    }

    private final List<List<Cell>> buildSection(SectionBuilderInstance section, int builderWidth) {
        int n = section.getRows().size();
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int n5 = n4 = (n3 = n2++);
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList(section.getRows().size()));
        }
        List rows = arrayList;
        Iterator<RowBuilderInstance> iterator = section.getRows().iterator();
        int n6 = 0;
        while (iterator.hasNext()) {
            int y = n6++;
            RowBuilderInstance row2 = iterator.next();
            int x = 0;
            for (CellBuilderInstance cellBuilder : row2.getCells()) {
                x = TableLayoutKt.access$findEmptyColumn(rows, x, y);
                this.insertCell(cellBuilder, section, rows, x, y, builderWidth);
                ++x;
            }
        }
        return rows;
    }

    private final void insertCell(CellBuilderInstance cell2, SectionBuilderInstance section, List<List<Cell>> rows, int startingX, int startingY, int builderWidth) {
        Widget widget;
        Comparable comparable;
        ColumnBuilder tableCol = this.table.getColumns().get(startingX);
        CellStyleBuilder sectionCol = section.getColumns().get(startingX);
        RowBuilderInstance row2 = section.getRows().get(startingY);
        Iterator iterator = ((Iterable)RangesKt.until((int)startingY, (int)(startingY + cell2.getRowSpan()))).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            int n;
            int it22 = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            RowBuilderInstance rowBuilderInstance = (RowBuilderInstance)CollectionsKt.getOrNull(section.getRows(), (int)it22);
            if (rowBuilderInstance == null) {
                n = 0;
            } else {
                int n2;
                List<CellBuilderInstance> list = rowBuilderInstance.getCells();
                n = list == null ? 0 : (n2 = list.size());
            }
            Comparable it22 = Integer.valueOf(n);
            while (iterator.hasNext()) {
                int n3;
                int it = ((IntIterator)iterator).nextInt();
                $i$a$-maxOfOrNull-TableLayout$insertCell$maxRowSize$1 = false;
                RowBuilderInstance rowBuilderInstance2 = (RowBuilderInstance)CollectionsKt.getOrNull(section.getRows(), (int)it);
                if (rowBuilderInstance2 == null) {
                    n3 = 0;
                } else {
                    int n4;
                    List<CellBuilderInstance> list = rowBuilderInstance2.getCells();
                    n3 = list == null ? 0 : (n4 = list.size());
                }
                if (it22.compareTo(it = (Comparable)Integer.valueOf(n3)) >= 0) continue;
                it22 = it;
            }
            comparable = it22;
        }
        Integer n = (Integer)comparable;
        int maxRowSize = n == null ? 0 : n;
        int columnSpan = RangesKt.coerceAtMost((int)cell2.getColumnSpan(), (int)(builderWidth - maxRowSize + 1));
        int rowSpan = RangesKt.coerceAtMost((int)cell2.getRowSpan(), (int)(rows.size() - startingY));
        Borders borders2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Borders.ALL, insertCell.borders.1.INSTANCE);
        Padding padding2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Padding.Companion.horizontal(1), insertCell.padding.1.INSTANCE);
        Whitespace whitespace2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Whitespace.PRE, insertCell.whitespace.1.INSTANCE);
        TextAlign textAlign2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, TextAlign.LEFT, insertCell.textAlign.1.INSTANCE);
        VerticalAlign verticalAlign2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, VerticalAlign.TOP, insertCell.verticalAlign.1.INSTANCE);
        OverflowWrap overflowWrap2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, OverflowWrap.ELLIPSES, insertCell.overflowWrap.1.INSTANCE);
        TextStyle stripedStyle = !((Collection)section.getRowStyles()).isEmpty() ? section.getRowStyles().get(startingY % section.getRowStyles().size()) : null;
        TextStyle[] textStyleArray = new TextStyle[7];
        textStyleArray[0] = cell2.getStyle();
        textStyleArray[1] = row2.getStyle();
        textStyleArray[2] = stripedStyle;
        CellStyleBuilder cellStyleBuilder = sectionCol;
        textStyleArray[3] = cellStyleBuilder == null ? null : cellStyleBuilder.getStyle();
        ColumnBuilder columnBuilder = tableCol;
        textStyleArray[4] = columnBuilder == null ? null : columnBuilder.getStyle();
        textStyleArray[5] = section.getStyle();
        textStyleArray[6] = this.table.getStyle();
        TextStyle style = TextStyleKt.foldStyles(textStyleArray);
        CellContent cellContent = cell2.getContent();
        if (cellContent instanceof CellContent.WidgetContent) {
            widget = ((CellContent.WidgetContent)cell2.getContent()).getWidget();
        } else if (cellContent instanceof CellContent.TextContent) {
            widget = new Text(((CellContent.TextContent)cell2.getContent()).getText(), whitespace2, textAlign2, overflowWrap2, null, null, 48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Widget content = PaddingKt.withPadding$default(widget, padding2, false, 2, null);
        Boolean bl = borders2.getRight();
        int n5 = bl.booleanValue();
        Boolean bl2 = borders2.getTop();
        Boolean bl3 = borders2.getLeft();
        int n6 = columnSpan;
        int n7 = rowSpan;
        Object object = content;
        boolean bl4 = false;
        boolean bl5 = columnSpan == 1;
        Boolean bl6 = bl5 ? bl : null;
        bl = borders2.getBottom();
        boolean it = bl;
        Boolean bl7 = bl6;
        boolean bl8 = false;
        boolean bl9 = rowSpan == 1;
        VerticalAlign verticalAlign3 = verticalAlign2;
        TextAlign textAlign3 = textAlign2;
        TextStyle textStyle = style;
        Boolean bl10 = bl9 ? bl : null;
        Boolean bl11 = bl7;
        Boolean bl12 = bl2;
        Boolean bl13 = bl3;
        int n8 = n6;
        int n9 = n7;
        Widget widget2 = object;
        Cell.Content builtCell = new Cell.Content(widget2, n9, n8, bl13, bl12, bl11, bl10, textStyle, textAlign3, verticalAlign3);
        int lastX = startingX + columnSpan - 1;
        n5 = startingX;
        if (n5 <= lastX) {
            int x;
            do {
                int y;
                x = n5++;
                int n10 = startingY;
                int lastY = startingY + rowSpan - 1;
                if (n10 > lastY) continue;
                do {
                    Cell cell3;
                    y = n10++;
                    if (x == startingX && y == startingY) {
                        cell3 = builtCell;
                    } else {
                        Boolean bl14 = borders2.getLeft();
                        boolean bl15 = bl14;
                        object = builtCell;
                        boolean bl16 = false;
                        n7 = x == startingX ? 1 : 0;
                        Boolean bl17 = n7 != 0 ? bl14 : null;
                        bl14 = borders2.getTop();
                        boolean it2 = bl14;
                        Boolean bl18 = bl17;
                        boolean bl19 = false;
                        n6 = y == startingY ? 1 : 0;
                        Boolean bl20 = n6 != 0 ? bl14 : null;
                        bl14 = borders2.getRight();
                        it2 = bl14;
                        Boolean bl21 = bl20;
                        boolean bl22 = false;
                        boolean bl23 = x == lastX;
                        Boolean bl24 = bl23 ? bl14 : null;
                        bl14 = borders2.getBottom();
                        it2 = bl14;
                        bl3 = bl24;
                        boolean bl25 = false;
                        bl2 = y == lastY;
                        Boolean bl26 = bl2 != false ? bl14 : null;
                        Boolean bl27 = bl3;
                        Boolean bl28 = bl21;
                        Boolean bl29 = bl18;
                        Object object2 = object;
                        cell3 = new Cell.SpanRef((Cell.Content)object2, bl29, bl28, bl27, bl26);
                    }
                    Cell c = cell3;
                    List tableRow = TableLayoutKt.access$getRow(rows, y);
                    Cell existing = TableLayoutKt.access$getCell(tableRow, x);
                    if (!(existing == Cell.Empty.INSTANCE)) {
                        boolean bl30 = false;
                        String string = "Invalid table: cell spans cannot overlap";
                        throw new IllegalArgumentException(string.toString());
                    }
                    tableRow.set(x, c);
                } while (y != lastY);
            } while (x != lastX);
        }
    }

    private static final <T> T insertCell$getStyle(CellBuilderInstance $cell, RowBuilderInstance row2, CellStyleBuilder sectionCol, ColumnBuilder tableCol, SectionBuilderInstance $section, TableLayout this$0, T t, Function1<? super CellStyleBuilder, ? extends T> getter) {
        Object object = getter.invoke((Object)$cell);
        if (object == null && (object = getter.invoke((Object)row2)) == null) {
            Object object2;
            CellStyleBuilder cellStyleBuilder = sectionCol;
            if (cellStyleBuilder == null) {
                object2 = null;
            } else {
                CellStyleBuilder cellStyleBuilder2 = cellStyleBuilder;
                object2 = object = getter.invoke((Object)cellStyleBuilder2);
            }
            if (object2 == null) {
                Object object3;
                Object object4;
                ColumnBuilder columnBuilder = tableCol;
                if (columnBuilder == null) {
                    object4 = null;
                } else {
                    object3 = columnBuilder;
                    object4 = object = getter.invoke(object3);
                }
                if (object4 == null && (object = getter.invoke((Object)$section)) == null) {
                    object3 = getter.invoke((Object)this$0.table);
                    object = object3 == null ? t : object3;
                }
            }
        }
        return (T)object;
    }
}

