/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.terminal.AnsiMovements;
import com.github.ajalt.mordant.terminal.CursorMovements;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.widgets.RawWidget;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\f2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/github/ajalt/mordant/terminal/PrintTerminalCursor;", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(Lcom/github/ajalt/mordant/terminal/Terminal;)V", "getTerminal", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "getMoves", "", "movements", "Lkotlin/Function1;", "Lcom/github/ajalt/mordant/terminal/CursorMovements;", "", "Lkotlin/ExtensionFunctionType;", "hide", "showOnExit", "", "move", "show", "mordant"})
public abstract class PrintTerminalCursor
implements TerminalCursor {
    @NotNull
    private final Terminal terminal;

    public PrintTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
    }

    @NotNull
    protected final Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public void show() {
        this.terminal.print(new RawWidget("\u001b[?25h"));
    }

    @Override
    public void hide(boolean showOnExit) {
        this.terminal.print(new RawWidget("\u001b[?25l"));
    }

    @Override
    public void move(@NotNull Function1<? super CursorMovements, Unit> movements) {
        Intrinsics.checkNotNullParameter(movements, (String)"movements");
        this.terminal.print(new RawWidget(this.getMoves(movements)));
    }

    @Override
    @NotNull
    public String getMoves(@NotNull Function1<? super CursorMovements, Unit> movements) {
        Intrinsics.checkNotNullParameter(movements, (String)"movements");
        AnsiMovements ansiMovements = new AnsiMovements();
        movements.invoke((Object)ansiMovements);
        return ansiMovements.getOutput();
    }
}

