/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eJE\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\b\u0010\u001f\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020\u0004H\u0002J\b\u0010!\u001a\u00020\u0004H\u0002\u00a8\u0006\""}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalDetection;", "", "()V", "ansiHyperLinks", "", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "interactive", "ciSupportsColor", "detectInitialSize", "Lkotlin/Pair;", "", "detectSize", "timeoutMs", "", "detectTerminal", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "stderr", "width", "height", "hyperlinks", "(ZLcom/github/ajalt/mordant/rendering/AnsiLevel;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "forcedColor", "getColorTerm", "", "getTerm", "getTermProgram", "hasIdeaEnvvar", "isCI", "isDomTerm", "isIntellijConsole", "isRecentITerm", "isVsCodeTerminal", "isWindowsTerminal", "mordant"})
public final class TerminalDetection {
    @NotNull
    public static final TerminalDetection INSTANCE = new TerminalDetection();

    private TerminalDetection() {
    }

    @NotNull
    public final TerminalInfo detectTerminal(boolean stderr, @Nullable AnsiLevel ansiLevel, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, @Nullable Boolean interactive) {
        boolean outputInteractive;
        boolean ij = this.isIntellijConsole();
        Boolean bl = interactive;
        boolean inputInteractive = bl == null ? (stderr ? false : ij || MppImplKt.stdinInteractive()) : bl;
        Boolean bl2 = interactive;
        boolean bl3 = bl2 == null ? ij || (stderr ? MppImplKt.stderrInteractive() : MppImplKt.stdoutInteractive()) : (outputInteractive = bl2.booleanValue());
        AnsiLevel ansiLevel2 = ansiLevel;
        if (ansiLevel2 == null) {
            ansiLevel2 = this.ansiLevel(outputInteractive);
        }
        AnsiLevel level = ansiLevel2;
        Boolean bl4 = hyperlinks;
        boolean ansiHyperLinks = bl4 == null ? outputInteractive && level != AnsiLevel.NONE && this.ansiHyperLinks() : bl4;
        Pair<Integer, Integer> pair = this.detectInitialSize();
        int w = ((Number)pair.component1()).intValue();
        int h = ((Number)pair.component2()).intValue();
        Integer n = width;
        Integer n2 = height;
        return new TerminalInfo(n == null ? w : n, n2 == null ? h : n2, level, ansiHyperLinks, outputInteractive, inputInteractive, ij);
    }

    @Nullable
    public final Pair<Integer, Integer> detectSize(long timeoutMs) {
        return MppImplKt.getTerminalSize(timeoutMs);
    }

    private final Pair<Integer, Integer> detectInitialSize() {
        Pair detected = MppImplKt.terminalSizeDetectionIsFast() ? MppImplKt.getTerminalSize(100L) : null;
        Pair pair = detected;
        if (pair == null) {
            int n;
            int n2;
            String string = MppImplKt.getEnv("COLUMNS");
            if (string == null) {
                n2 = 79;
            } else {
                Integer n3 = StringsKt.toIntOrNull((String)string);
                n2 = n3 == null ? 79 : n3;
            }
            Integer n4 = n2;
            String string2 = MppImplKt.getEnv("LINES");
            if (string2 == null) {
                n = 24;
            } else {
                Integer n5 = StringsKt.toIntOrNull((String)string2);
                n = n5 == null ? 24 : n5;
            }
            pair = TuplesKt.to((Object)n4, (Object)n);
        }
        return pair;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean ansiHyperLinks() {
        boolean bl;
        if (this.forcedColor() == AnsiLevel.NONE) return false;
        if (this.isWindowsTerminal()) return true;
        String string = this.getTermProgram();
        if (string == null) return false;
        int n = -1;
        switch (string.hashCode()) {
            case 1246525912: {
                if (string.equals("wezterm")) {
                    n = 1;
                }
                break;
            }
            case -1987176184: {
                if (string.equals("iterm.app")) {
                    n = 2;
                }
                break;
            }
            case 99761772: {
                if (string.equals("hyper")) {
                    n = 1;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                bl = this.isRecentITerm();
                break;
            }
            default: {
                return false;
            }
        }
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AnsiLevel ansiLevel(boolean interactive) {
        AnsiLevel ansiLevel;
        Object object;
        Object[] objectArray;
        Pair pair;
        String it;
        int n;
        AnsiLevel ansiLevel2 = this.forcedColor();
        if (ansiLevel2 != null) {
            return ansiLevel2;
        }
        if (this.isIntellijConsole()) return AnsiLevel.TRUECOLOR;
        if (this.isVsCodeTerminal()) {
            return AnsiLevel.TRUECOLOR;
        }
        if (!interactive) {
            return AnsiLevel.NONE;
        }
        if (this.isWindowsTerminal()) return AnsiLevel.TRUECOLOR;
        if (this.isDomTerm()) {
            return AnsiLevel.TRUECOLOR;
        }
        String string = this.getColorTerm();
        if (string != null) {
            n = -1;
            switch (string.hashCode()) {
                case 47822731: {
                    if (!string.equals("24bit")) break;
                    n = 1;
                    break;
                }
                case 1482504776: {
                    if (!string.equals("24bits")) break;
                    n = 1;
                    break;
                }
                case 1350697621: {
                    if (!string.equals("truecolor")) break;
                    n = 1;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return AnsiLevel.TRUECOLOR;
                }
            }
        }
        if (this.isCI()) {
            AnsiLevel ansiLevel3;
            if (this.ciSupportsColor()) {
                ansiLevel3 = AnsiLevel.ANSI256;
                return ansiLevel3;
            }
            ansiLevel3 = AnsiLevel.NONE;
            return ansiLevel3;
        }
        string = this.getTermProgram();
        if (string != null) {
            tmp = -1;
            switch (string.hashCode()) {
                case 1246525912: {
                    if (!string.equals("wezterm")) break;
                    tmp = 1;
                    break;
                }
                case -1987176184: {
                    if (!string.equals("iterm.app")) break;
                    tmp = 2;
                    break;
                }
                case 1015440833: {
                    if (!string.equals("apple_terminal")) break;
                    tmp = 3;
                    break;
                }
                case 99761772: {
                    if (!string.equals("hyper")) break;
                    tmp = 4;
                    break;
                }
            }
            switch (tmp) {
                case 4: {
                    return AnsiLevel.TRUECOLOR;
                }
                case 3: {
                    return AnsiLevel.ANSI256;
                }
                case 2: {
                    AnsiLevel ansiLevel4;
                    if (this.isRecentITerm()) {
                        ansiLevel4 = AnsiLevel.TRUECOLOR;
                        return ansiLevel4;
                    }
                    ansiLevel4 = AnsiLevel.ANSI256;
                    return ansiLevel4;
                }
                case 1: {
                    return AnsiLevel.TRUECOLOR;
                }
            }
        }
        if ((it = this.getTerm()) == null) {
            pair = null;
        } else {
            objectArray = new String[]{"-"};
            object = StringsKt.split$default((CharSequence)it, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
            if (object == null) {
                pair = null;
            } else {
                Object it2 = object;
                boolean bl = false;
                pair = TuplesKt.to((Object)CollectionsKt.firstOrNull((List)it2), (Object)CollectionsKt.lastOrNull((List)it2));
            }
        }
        Pair pair2 = pair;
        string = pair2 == null ? TuplesKt.to(null, null) : pair2;
        String term = (String)string.component1();
        String level = (String)string.component2();
        object = level;
        if (object != null) {
            tmp = -1;
            switch (((String)object).hashCode()) {
                case -1619924752: {
                    if (!((String)object).equals("256color")) break;
                    tmp = 1;
                    break;
                }
                case 47822731: {
                    if (!((String)object).equals("24bit")) break;
                    tmp = 2;
                    break;
                }
                case 49747: {
                    if (!((String)object).equals("256")) break;
                    tmp = 1;
                    break;
                }
                case 1482504776: {
                    if (!((String)object).equals("24bits")) break;
                    tmp = 2;
                    break;
                }
                case 1350697621: {
                    if (!((String)object).equals("truecolor")) break;
                    tmp = 2;
                    break;
                }
                case 1321940355: {
                    if (!((String)object).equals("256colors")) break;
                    tmp = 1;
                    break;
                }
                case -1331586071: {
                    if (!((String)object).equals("direct")) break;
                    tmp = 2;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    return AnsiLevel.ANSI256;
                }
                case 2: {
                    return AnsiLevel.TRUECOLOR;
                }
            }
        }
        if ((object = term) != null) {
            tmp = -1;
            switch (((String)object).hashCode()) {
                case 3515268: {
                    if (!((String)object).equals("rxvt")) break;
                    tmp = 1;
                    break;
                }
                case -1345749109: {
                    if (!((String)object).equals("cygwin")) break;
                    tmp = 2;
                    break;
                }
                case 94842723: {
                    if (!((String)object).equals("color")) break;
                    tmp = 1;
                    break;
                }
                case 114378980: {
                    if (!((String)object).equals("xterm")) break;
                    tmp = 1;
                    break;
                }
                case 112480882: {
                    if (!((String)object).equals("vt220")) break;
                    tmp = 1;
                    break;
                }
                case 112479859: {
                    if (!((String)object).equals("vt100")) break;
                    tmp = 1;
                    break;
                }
                case 102977780: {
                    if (!((String)object).equals("linux")) break;
                    tmp = 1;
                    break;
                }
                case -538394785: {
                    if (!((String)object).equals("konsole")) break;
                    tmp = 1;
                    break;
                }
                case -907689876: {
                    if (!((String)object).equals("screen")) break;
                    tmp = 1;
                    break;
                }
                case 3095014: {
                    if (!((String)object).equals("dumb")) break;
                    tmp = 3;
                    break;
                }
                case 3564252: {
                    if (!((String)object).equals("tmux")) break;
                    tmp = 1;
                    break;
                }
                case 2999107: {
                    if (!((String)object).equals("ansi")) break;
                    tmp = 1;
                    break;
                }
            }
            switch (tmp) {
                case 2: {
                    objectArray = new String[]{"Windows 10", "Windows 11"};
                    if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)MppImplKt.getJavaProperty("os.name"))) {
                        ansiLevel = AnsiLevel.TRUECOLOR;
                        return ansiLevel;
                    }
                    ansiLevel = AnsiLevel.ANSI256;
                    return ansiLevel;
                }
                case 1: {
                    ansiLevel = AnsiLevel.ANSI16;
                    return ansiLevel;
                }
                case 3: {
                    ansiLevel = AnsiLevel.NONE;
                    return ansiLevel;
                }
            }
        }
        ansiLevel = AnsiLevel.NONE;
        return ansiLevel;
    }

    private final String getTerm() {
        String string;
        String string2 = MppImplKt.getEnv("TERM");
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            string = string3;
        }
        return string;
    }

    private final String getColorTerm() {
        String string;
        String string2 = MppImplKt.getEnv("COLORTERM");
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            string = string3;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AnsiLevel forcedColor() {
        AnsiLevel ansiLevel;
        if (Intrinsics.areEqual((Object)this.getTerm(), (Object)"dumb")) {
            ansiLevel = AnsiLevel.NONE;
            return ansiLevel;
        }
        if (MppImplKt.getEnv("NO_COLOR") != null) {
            ansiLevel = AnsiLevel.NONE;
            return ansiLevel;
        }
        String string = MppImplKt.getEnv("FORCE_COLOR");
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string3 = string2;
        String string4 = string3;
        if (string4 == null) return null;
        int n = -1;
        switch (string4.hashCode()) {
            case 48: {
                if (string4.equals("0")) {
                    n = 1;
                }
                break;
            }
            case 0: {
                if (string4.equals("")) {
                    n = 2;
                }
                break;
            }
            case -2116143010: {
                if (string4.equals("16color")) {
                    n = 2;
                }
                break;
            }
            case 49: {
                if (string4.equals("1")) {
                    n = 2;
                }
                break;
            }
            case -1619924752: {
                if (string4.equals("256color")) {
                    n = 3;
                }
                break;
            }
            case 50: {
                if (string4.equals("2")) {
                    n = 3;
                }
                break;
            }
            case 51: {
                if (string4.equals("3")) {
                    n = 4;
                }
                break;
            }
            case 1350697621: {
                if (string4.equals("truecolor")) {
                    n = 4;
                }
                break;
            }
            case 97196323: {
                if (string4.equals("false")) {
                    n = 1;
                }
                break;
            }
            case 3569038: {
                if (string4.equals("true")) {
                    n = 2;
                }
                break;
            }
            case 3387192: {
                if (string4.equals("none")) {
                    n = 1;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                ansiLevel = AnsiLevel.NONE;
                return ansiLevel;
            }
            case 2: {
                ansiLevel = AnsiLevel.ANSI16;
                return ansiLevel;
            }
            case 3: {
                ansiLevel = AnsiLevel.ANSI256;
                return ansiLevel;
            }
            case 4: {
                ansiLevel = AnsiLevel.TRUECOLOR;
                return ansiLevel;
            }
            default: {
                return null;
            }
        }
    }

    private final String getTermProgram() {
        String string;
        String string2 = MppImplKt.getEnv("TERM_PROGRAM");
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            string = string3;
        }
        return string;
    }

    private final boolean isVsCodeTerminal() {
        return Intrinsics.areEqual((Object)this.getTermProgram(), (Object)"vscode");
    }

    private final boolean isWindowsTerminal() {
        CharSequence charSequence = MppImplKt.getEnv("WT_SESSION");
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isDomTerm() {
        CharSequence charSequence = MppImplKt.getEnv("DOMTERM");
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isRecentITerm() {
        Integer n;
        String string = MppImplKt.getEnv("TERM_PROGRAM_VERSION");
        if (string == null) {
            n = null;
        } else {
            String[] stringArray = new String[]{"."};
            List list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (list == null) {
                n = null;
            } else {
                String string2 = (String)CollectionsKt.firstOrNull((List)list);
                n = string2 == null ? null : StringsKt.toIntOrNull((String)string2);
            }
        }
        Integer ver = n;
        return ver != null && ver >= 3;
    }

    private final boolean isCI() {
        return MppImplKt.getEnv("CI") != null;
    }

    private final boolean ciSupportsColor() {
        boolean bl;
        block3: {
            Object[] objectArray = new String[]{"APPVEYOR", "BUILDKITE", "CIRCLECI", "DRONE", "GITHUB_ACTIONS", "GITLAB_CI", "TRAVIS"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(MppImplKt.getEnv(it) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isIntellijConsole() {
        return this.hasIdeaEnvvar() || MppImplKt.runningInIdeaJavaAgent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasIdeaEnvvar() {
        boolean bl;
        if (MppImplKt.getEnv("IDEA_INITIAL_DIRECTORY") != null) return true;
        if (MppImplKt.getEnv("__INTELLIJ_COMMAND_HISTFILE__") != null) return true;
        String string = MppImplKt.getEnv("TERMINAL_EMULATOR");
        if (string == null) {
            bl = false;
        } else {
            if (StringsKt.contains((CharSequence)string, (CharSequence)"jetbrains", (boolean)true)) {
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        String string2 = MppImplKt.getJavaProperty("sun.java.command");
        if (string2 == null) {
            return false;
        }
        if (!StringsKt.contains((CharSequence)string2, (CharSequence)"idea", (boolean)true)) return false;
        return true;
    }
}

