/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.widgets.ProgressCell;
import com.github.ajalt.mordant.widgets.ProgressState;
import com.github.ajalt.mordant.widgets.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/ajalt/mordant/widgets/EtaProgressCell;", "Lcom/github/ajalt/mordant/widgets/ProgressCell;", "prefix", "", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "animationRate", "Lcom/github/ajalt/mordant/widgets/ProgressCell$AnimationRate;", "getAnimationRate", "()Lcom/github/ajalt/mordant/widgets/ProgressCell$AnimationRate;", "columnWidth", "Lcom/github/ajalt/mordant/table/ColumnWidth;", "getColumnWidth", "()Lcom/github/ajalt/mordant/table/ColumnWidth;", "text", "Lcom/github/ajalt/mordant/widgets/Text;", "s", "makeWidget", "Lcom/github/ajalt/mordant/rendering/Widget;", "Lcom/github/ajalt/mordant/widgets/ProgressState;", "mordant"})
public final class EtaProgressCell
implements ProgressCell {
    @NotNull
    private final String prefix;
    @NotNull
    private final TextStyle style;

    public EtaProgressCell(@NotNull String prefix, @NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.prefix = prefix;
        this.style = style;
    }

    @Override
    @NotNull
    public ProgressCell.AnimationRate getAnimationRate() {
        return ProgressCell.AnimationRate.TEXT;
    }

    @Override
    @NotNull
    public ColumnWidth getColumnWidth() {
        return new ColumnWidth.Fixed(7 + this.prefix.length());
    }

    @Override
    @NotNull
    public Widget makeWidget(@NotNull ProgressState $this$makeWidget) {
        Intrinsics.checkNotNullParameter((Object)$this$makeWidget, (String)"<this>");
        double eta = $this$makeWidget.getTotal() == null ? 0.0 : (double)($this$makeWidget.getTotal() - $this$makeWidget.getCompleted()) / $this$makeWidget.getCompletedPerSecond();
        int maxEta = 35999;
        if ($this$makeWidget.getIndeterminate() || eta < 0.0 || $this$makeWidget.getCompletedPerSecond() == 0.0 || eta > (double)maxEta) {
            return this.text(Intrinsics.stringPlus((String)this.prefix, (Object)"-:--:--"));
        }
        int h = (int)(eta / (double)3600);
        int m = (int)(eta / (double)60 % (double)60);
        int s = MathKt.roundToInt((double)(eta % (double)60));
        return this.text(this.prefix + h + ':' + StringsKt.padStart((String)String.valueOf(m), (int)2, (char)'0') + ':' + StringsKt.padStart((String)String.valueOf(s), (int)2, (char)'0'));
    }

    private final Text text(String s) {
        return new Text(this.style.invoke(s), Whitespace.PRE, null, null, null, null, 60, null);
    }
}

